/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.form.web.controller;

import com.suncode.pwfl.form.dto.user.UserDto;
import com.suncode.pwfl.form.service.UserTableService;
import com.suncode.pwfl.form.util.object.PagingInfo;
import com.suncode.pwfl.form.util.object.SortInfo;
import com.suncode.pwfl.form.web.form.UserTableFilterForm;
import com.suncode.pwfl.form.web.result.DataSubmitResult;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/form/userTable"})
public class UserTableController {
    @Autowired
    private UserTableService userTableService;

    @RequestMapping(value={"/load"}, method={RequestMethod.GET})
    @ResponseBody
    public DataSubmitResult<UserDto> load(UserTableFilterForm form, PagingInfo pagingInfo, SortInfo sortInfo) {
        String firstName = form.getFirstName();
        String lastName = form.getLastName();
        String userName = form.getUserName();
        List users = this.userTableService.load(firstName, lastName, userName, pagingInfo, sortInfo);
        long total = this.userTableService.countAll(firstName, lastName, userName);
        DataSubmitResult result = new DataSubmitResult();
        result.setData(users);
        result.setTotal(total);
        result.setSuccess(true);
        return result;
    }
}

