var SuncodeFormService = {
    config: {},
    onReadyEvents: [],
    
    addOnReadyEvent: function( event ) {
        if ( typeof ( event ) == 'function' ) {
            this.onReadyEvents.push( event );
        }
    },
    hasOnReadyEvents: function() {
        return this.onReadyEvents.size() > 0;
    },
    getOnReadyEvents: function() {
        return this.onReadyEvents;
    },
    
    suspendLayouts: function(fn, scope){
    	Ext4.suspendLayouts();
    	if(Ext.isFunction(fn)){
    		try {
    			fn.call(scope || window);
    		}
    		finally {
    			SuncodeFormService.resumeLayouts();
    		}
    	}
    },
    resumeLayouts: function(){
        Ext4.resumeLayouts(true);
    },
    
    
    
    /**
     * Ustawia wartość właściwości o podanej nazwie.
     * 
     * @param name nazwa właściwości
     * @param value wartość właściwości
     */
    setConfig: function(name, value){
        this.config[name] = value;
    },
    
    /**
     * Pobiera wartość właściwości o podanej nazwie.
     * 
     * @param name nazwa właściwości
     * @param defaultValue domyśla wartość, jeżeli znaleziona wartość nie istnieje lub jest pusta
     */
    getConfig: function(name, defaultValue){
        var value = this.config[name];
        return Ext.isEmpty(value, true) ? defaultValue : value;
    }
};