/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.form.web.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.plusmpm.security.WorkflowPrincipal;
import com.plusmpm.security.authentication.AbstractAuthenticator;
import com.plusmpm.security.authentication.Authenticator;
import com.plusmpm.security.authentication.AuthenticatorFactory;
import com.suncode.pwfl.administration.user.Domain;
import com.suncode.pwfl.administration.user.DomainService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.form.language.FormTranslator;
import com.suncode.pwfl.form.service.FormService;
import com.suncode.pwfl.form.util.FormUtils;
import com.suncode.pwfl.form.util.object.ActivityAcceptance;
import com.suncode.pwfl.form.util.object.ComboBoxesValidation;
import com.suncode.pwfl.form.validator.MaxLengthValidator;
import com.suncode.pwfl.form.web.result.AcceptActivityResult;
import com.suncode.pwfl.form.web.result.ComboBoxesValidationResult;
import com.suncode.pwfl.form.web.result.SubmitResult;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.activity.sequential.SequentialMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/form"})
public class FormController {
    private static final Logger log = LoggerFactory.getLogger(FormController.class);
    private static ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private FormService formService;
    @Autowired
    private FormTranslator formTranslator;
    private static final String DOMAIN_ID_ATTR_NAME = "domain";
    private static final String USER_DOMAIN_SPLIT_SIGN = "/";

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    public SubmitResult save(HttpServletRequest request, @RequestParam(value="processId", required=false) String processId, @RequestParam(value="activityId", required=false) String activityId) {
        if (processId == null || activityId == null) {
            String missingParams = processId == null ? "processId" : "";
            missingParams = missingParams + (activityId == null ? " activityId" : "");
            return this.createServerParamsToLowErrorResult(missingParams);
        }
        SubmitResult result = new SubmitResult();
        Locale locale = LocaleContextHolder.getLocale();
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        boolean success = this.formService.save(processId, activityId, userId, request.getParameterMap(), locale);
        if (success) {
            result.setMessage(this.formTranslator.translateMessage(locale, "Formularz_zostal_zapisany"));
            result.setSuccess(true);
            request.setAttribute("auditSuccess", (Object)true);
        } else {
            result.setMessage(this.formTranslator.translateMessage(locale, "Wystapil_blad_podczas_zapisywania_formularza"));
            result.setSuccess(false);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processId", processId);
        params.put("activityId", activityId);
        request.setAttribute("audit", (Object)AuditBuilder.getInstance().type(AuditTypes.AUDIT_SAVE_ACTIVITY).success(success).params(params).build());
        return result;
    }

    @RequestMapping(value={"/accept"}, method={RequestMethod.POST})
    @ResponseBody
    public AcceptActivityResult accept(HttpServletRequest request, HttpSession session, @RequestParam(value="processId", required=false) String processId, @RequestParam(value="activityId", required=false) String activityId, @RequestParam(value="actionName", required=false) String actionName, @RequestParam(value="#viewId", required=false) Long viewId, @RequestParam(value="#sequentialMode", required=false, defaultValue="default") String sequentialMode, @RequestParam(value="password", required=false) String password, @RequestParam(value="#skipConfirmations", required=false) boolean skipConfirmations, @RequestParam(value="#redirect", required=false) String redirect, @RequestParam(value="#processDefId", required=false) String processDefId, @RequestParam(value="#confirmedValidators", required=false) String confirmedValidatorsJson, @RequestParam(value="#source", required=false) String source) {
        if (processId == null || activityId == null) {
            String missingParams = processId == null ? "processId" : "";
            missingParams = missingParams + (activityId == null ? " activityId" : "");
            return this.createServerParamsToLowErrorResult(missingParams);
        }
        if (redirect.contains("ShowCalendar.do")) {
            redirect = "ShowWorkListAction.do";
        }
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        Locale locale = LocaleContextHolder.getLocale();
        if (this.shouldBuildValidationExceptionResult(processDefId, userId, password, request.getSession(false))) {
            return this.buildValidationExceptionResult(this.buildAuthorizationFailedMessage(locale), true);
        }
        AuditTypes auditType = null;
        ActivityAcceptance activityAcceptance = new ActivityAcceptance();
        try {
            HashSet confirmedValidators = StringUtils.isBlank((CharSequence)confirmedValidatorsJson) ? Sets.newHashSet() : (Set)mapper.readValue(confirmedValidatorsJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            this.formService.accept(activityAcceptance, processId, activityId, actionName, userId, "", request.getParameterMap(), skipConfirmations, locale, redirect, (Set)confirmedValidators, session.getId(), SequentialMode.valueOf((String)sequentialMode.toUpperCase()), viewId, source, null);
        }
        catch (Exception e) {
            activityAcceptance.setAuditSuccess(Boolean.valueOf(false));
            activityAcceptance.setSuccess(false);
            auditType = AuditTypes.AUDIT_ACCEPT_ACTIVITY;
            log.error(e.getMessage(), (Throwable)e);
        }
        AcceptActivityResult result = this.finalizeActivityAcceptance(activityAcceptance);
        request.setAttribute("auditSuccess", (Object)activityAcceptance.getAuditSuccess());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processId", processId);
        params.put("activityId", activityId);
        params.put("actionName", actionName);
        if (auditType == null) {
            auditType = CollectionUtils.isEmpty((Collection)result.getConfirmations()) && result.isSuccess() ? AuditTypes.AUDIT_ACCEPT_ACTIVITY : AuditTypes.AUDIT_VALIDATE_ACTIVITY;
        }
        boolean success = auditType == AuditTypes.AUDIT_ACCEPT_ACTIVITY ? result.isSuccess() : false;
        request.setAttribute("audit", (Object)AuditBuilder.getInstance().type(auditType).success(success).params(params).build());
        return result;
    }

    @RequestMapping(value={"/acceptPreview"}, method={RequestMethod.POST})
    @ResponseBody
    public AcceptActivityResult acceptPreview(HttpServletRequest request, @RequestParam(value="processId", required=false) String processId, @RequestParam(value="activityId", required=false) String activityId, @RequestParam(value="actionName", required=false) String actionName, @RequestParam(value="password", required=false) String password, @RequestParam(value="#skipConfirmations", required=false) boolean skipConfirmations, @RequestParam(value="#contextMap", required=false) String contextMap, @RequestParam(value="#xpdl", required=false) String xpdl, @RequestParam(value="#processDefId", required=false) String processDefId, @RequestParam(value="#activityDefId", required=false) String activityDefId, @RequestParam(value="#confirmedValidators", required=false) String confirmedValidatorsJson) throws Exception {
        if (processDefId == null || activityDefId == null) {
            String missingParams = processDefId == null ? "processDefId" : "";
            missingParams = missingParams + (activityDefId == null ? " activityDefId" : "");
            return this.createServerParamsToLowErrorResult(missingParams);
        }
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        Locale locale = LocaleContextHolder.getLocale();
        if (this.shouldBuildValidationExceptionResult(processDefId, userId, password, request.getSession(false))) {
            return this.buildValidationExceptionResult(this.buildAuthorizationFailedMessage(locale), true);
        }
        ActivityAcceptance activityAcceptance = new ActivityAcceptance();
        HashSet confirmedValidators = StringUtils.isBlank((CharSequence)confirmedValidatorsJson) ? Sets.newHashSet() : (Set)mapper.readValue(confirmedValidatorsJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        try {
            this.formService.acceptPreview(activityAcceptance, contextMap, xpdl, processDefId, activityDefId, actionName, userId, "", request.getParameterMap(), skipConfirmations, locale, (Set)confirmedValidators);
        }
        catch (Exception ex) {
            activityAcceptance.setAuditSuccess(Boolean.valueOf(false));
            activityAcceptance.setSuccess(false);
            activityAcceptance.addMessage(this.formTranslator.translateMessage(locale, "Wystapil_blad_podczas_akceptacji_zadania"));
            log.error(ex.getMessage(), (Throwable)ex);
        }
        AcceptActivityResult result = this.finalizeActivityAcceptance(activityAcceptance);
        return result;
    }

    private boolean shouldBuildValidationExceptionResult(String processDefId, String userId, String password, HttpSession session) {
        return FormUtils.shouldAcceptTaskWithPassword((String)processDefId) && this.isUserUnauthorized(userId, password, session);
    }

    private AcceptActivityResult buildValidationExceptionResult(String message, boolean resetPassword) {
        AcceptActivityResult result = new AcceptActivityResult();
        result.setSuccess(false);
        result.setResetPassword(Boolean.valueOf(resetPassword));
        result.setMessages(this.buildValidationExceptionMessages(message));
        return result;
    }

    private List<String> buildValidationExceptionMessages(String message) {
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(message);
        return messages;
    }

    private boolean isUserUnauthorized(String login, String password, HttpSession session) {
        String domainId = StringUtils.defaultString((String)((String)session.getAttribute(DOMAIN_ID_ATTR_NAME)));
        WorkflowPrincipal principal = domainId.compareTo("plusworkflow") == 0 ? this.buildDefaultDomainPrincipal(login, password) : this.buildDomainPrincipal(domainId, login, password);
        Authenticator authenticator = AuthenticatorFactory.getAuthenticator((WorkflowPrincipal)principal, (HttpSession)session);
        AbstractAuthenticator.InternalAuthenticationResult authenticationResult = authenticator.authenticate();
        if (authenticationResult.authenticated()) {
            authenticationResult.registrateInSession();
            return false;
        }
        return true;
    }

    private WorkflowPrincipal buildDefaultDomainPrincipal(String login, String password) {
        return new WorkflowPrincipal(login, password);
    }

    private WorkflowPrincipal buildDomainPrincipal(String domainId, String login, String password) {
        DomainService domainService = (DomainService)SpringContext.getBean(DomainService.class);
        Domain domain = domainService.getDomain(new Long(domainId));
        String loginWithoutDomain = this.getLoginWithoutDomain(login);
        return new WorkflowPrincipal(loginWithoutDomain, password, domainId, domain.getDomainName());
    }

    private String getLoginWithoutDomain(String login) {
        String[] splittedLogin = login.split(USER_DOMAIN_SPLIT_SIGN, 2);
        if (splittedLogin.length == 2) {
            return splittedLogin[1];
        }
        return login;
    }

    private String buildAuthorizationFailedMessage(Locale locale) {
        return this.formTranslator.translateMessage(locale, "Autoryzacja_zakonczona_niepomyslnie") + ".";
    }

    private AcceptActivityResult finalizeActivityAcceptance(ActivityAcceptance activityAcceptance) {
        AcceptActivityResult result = new AcceptActivityResult();
        if (activityAcceptance.isSuccess()) {
            result.setConfirmations(activityAcceptance.getConfirmations());
            result.setForwardUrl(activityAcceptance.getForwardUrl());
            result.setSuccess(true);
        } else {
            result.setSuccess(false);
            result.setErrors(activityAcceptance.getErrors());
            result.setMessages(activityAcceptance.getMessages());
            result.setCallbackValidators(activityAcceptance.getCallbackValidators());
            result.setErrorCells(activityAcceptance.getErrorCells());
        }
        return result;
    }

    private AcceptActivityResult createServerParamsToLowErrorResult(String missingParams) {
        Locale locale = LocaleContextHolder.getLocale();
        ActivityAcceptance activityAcceptance = new ActivityAcceptance();
        activityAcceptance.setSuccess(false);
        String msg = this.formTranslator.translateMessage(locale, "Brak_parametrow") + ":" + missingParams + ". " + this.formTranslator.translateMessage(locale, "Parametry_serwera_zbyt_niskie");
        activityAcceptance.setMessages(Arrays.asList(msg));
        log.error("Brak parametr\u00f3w: " + missingParams + ". Prawdopodobnie parametry serwera maxPostSize i maxHttpHeader maj\u0105 zbyt niskie warto\u015bci");
        return this.finalizeActivityAcceptance(activityAcceptance);
    }

    @RequestMapping(value={"/validateComboBoxes"}, method={RequestMethod.POST})
    @ResponseBody
    public ComboBoxesValidationResult validateComboBoxes(HttpServletRequest request, @RequestParam(value="processId") String processId, @RequestParam(value="activityId") String activityId, @RequestParam(value="checkForm", required=false) boolean checkForm) {
        Locale locale = LocaleContextHolder.getLocale();
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        ComboBoxesValidation comboBoxesValidation = this.formService.validateComboBoxes(processId, activityId, userId, request.getParameterMap(), checkForm, locale);
        return this.finalizeComboBoxesValidation(comboBoxesValidation);
    }

    private ComboBoxesValidationResult finalizeComboBoxesValidation(ComboBoxesValidation comboBoxesValidation) {
        ComboBoxesValidationResult result = new ComboBoxesValidationResult();
        if (comboBoxesValidation.isSuccess()) {
            result.setSuccess(true);
        } else {
            result.setSuccess(false);
            result.setErrors(comboBoxesValidation.getErrors());
            result.setMessages(comboBoxesValidation.getMessages());
            result.setErrorCells(comboBoxesValidation.getErrorCells());
        }
        return result;
    }

    @RequestMapping(value={"/variableMaxLength"})
    @ResponseBody
    public int validateComboBoxes(HttpServletRequest request, @RequestParam(value="processDefId", required=false) String processDefId, @RequestParam(value="variableId", required=false) String variableId) {
        return MaxLengthValidator.getColumnLengthFromBaseProperties((String)processDefId, (String)variableId);
    }
}

