/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.form.web.controller.sequential;

import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.form.web.controller.sequential.SequentialActivityResponse;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.workflow.activity.sequential.SequentialActivityCacheService;
import com.suncode.pwfl.workflow.activity.sequential.SequentialActivityService;
import com.suncode.pwfl.workflow.activity.sequential.cache.SequentialActivity;
import com.suncode.pwfl.workflow.activity.sequential.cache.SequentialCacheKeyId;
import com.suncode.pwfl.workflow.activity.sequential.cache.SequentialCacheSourceType;
import com.suncode.pwfl.workflow.activity.sequential.cache.activities.SequentialCacheKeyUserActivities;
import com.suncode.pwfl.workflow.activity.sequential.cache.view.SequentialCacheKeyViewId;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"form/sequential"})
public class SequentialActivityController {
    @Autowired
    private SequentialActivityService sequentialActivityService;
    @Autowired
    private SequentialActivityCacheService sequentialActivityCacheService;

    @ResponseBody
    @RequestMapping(value={"next"})
    public SequentialActivityResponse getNext(@RequestParam String processId, @RequestParam String activityId, @RequestParam(required=false) Long viewId, @RequestParam String acceptanceSource, HttpSession session) {
        String username = UserContext.current().getUser().getUserName();
        SequentialCacheSourceType sequentialCacheSourceType = SequentialCacheSourceType.valueOf((String)acceptanceSource.toUpperCase());
        SequentialCacheKeyViewId sequentialCacheKeyId = null;
        String sessionId = session.getId();
        if (sequentialCacheSourceType == SequentialCacheSourceType.VIEW && viewId != null) {
            sequentialCacheKeyId = new SequentialCacheKeyViewId(sessionId, viewId);
        } else if (sequentialCacheSourceType == SequentialCacheSourceType.USER_ACTIVITIES) {
            sequentialCacheKeyId = new SequentialCacheKeyUserActivities(sessionId);
        }
        Optional optionalActivity = this.sequentialActivityService.next((SequentialCacheKeyId)sequentialCacheKeyId, sequentialCacheSourceType, new SequentialActivity(processId, activityId), username);
        return optionalActivity.map(activity -> new SequentialActivityResponse(Boolean.valueOf(true), activity)).orElseGet(() -> new SequentialActivityResponse(Boolean.valueOf(false)));
    }

    @ResponseBody
    @RequestMapping(value={"previous"})
    public SequentialActivityResponse getPrevious(@RequestParam String processId, @RequestParam String activityId, @RequestParam Long viewId, @RequestParam String acceptanceSource, HttpSession session) {
        String username = UserContext.current().getUser().getUserName();
        SequentialCacheSourceType sequentialCacheSourceType = SequentialCacheSourceType.valueOf((String)acceptanceSource.toUpperCase());
        SequentialCacheKeyViewId sequentialCacheKeyId = null;
        String sessionId = session.getId();
        if (sequentialCacheSourceType == SequentialCacheSourceType.VIEW && viewId != null) {
            sequentialCacheKeyId = new SequentialCacheKeyViewId(sessionId, viewId);
        } else if (sequentialCacheSourceType == SequentialCacheSourceType.USER_ACTIVITIES) {
            sequentialCacheKeyId = new SequentialCacheKeyUserActivities(sessionId);
        }
        Optional optionalActivity = this.sequentialActivityService.previous((SequentialCacheKeyId)sequentialCacheKeyId, sequentialCacheSourceType, new SequentialActivity(processId, activityId), username);
        return optionalActivity.map(activity -> new SequentialActivityResponse(Boolean.valueOf(true), activity)).orElseGet(() -> new SequentialActivityResponse(Boolean.valueOf(false)));
    }

    @ResponseBody
    @RequestMapping(value={"view/{viewId}/invalidate"}, method={RequestMethod.PATCH})
    public RestResult invalidate(HttpServletRequest request, @PathVariable Long viewId, @RequestParam String acceptanceSource) {
        SequentialCacheSourceType sequentialCacheSourceType = SequentialCacheSourceType.valueOf((String)acceptanceSource.toUpperCase());
        SequentialCacheKeyViewId sequentialCacheKeyId = null;
        String sessionId = request.getSession(false).getId();
        if (sequentialCacheSourceType == SequentialCacheSourceType.VIEW && viewId != null) {
            sequentialCacheKeyId = new SequentialCacheKeyViewId(sessionId, viewId);
        } else if (sequentialCacheSourceType == SequentialCacheSourceType.USER_ACTIVITIES) {
            sequentialCacheKeyId = new SequentialCacheKeyUserActivities(sessionId);
        }
        this.sequentialActivityCacheService.invalidate((SequentialCacheKeyId)sequentialCacheKeyId, sequentialCacheSourceType);
        return new RestResult(true);
    }

    @ResponseBody
    @RequestMapping(value={"enabled"}, method={RequestMethod.GET})
    public Boolean isFeatureEnabled() {
        return this.sequentialActivityService.hasFeature();
    }
}

