/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.form.web.controller;

import com.suncode.pwfl.form.dto.comments.CommentDto;
import com.suncode.pwfl.form.language.FormTranslator;
import com.suncode.pwfl.form.service.CommentsService;
import com.suncode.pwfl.form.util.FormUtils;
import com.suncode.pwfl.form.web.form.CommentForm;
import com.suncode.pwfl.form.web.form.CommentsForm;
import com.suncode.pwfl.form.web.result.SubmitResult;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.util.exception.EmptyPropertyException;
import com.suncode.pwfl.workflow.process.CommentService;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/form/comments"})
public class CommentsController {
    private static final String PDF_CONTENT_TYPE = "application/pdf";
    @Autowired
    private CommentsService commentsService;
    @Autowired
    private CommentService commentService;
    @Autowired
    private FormTranslator formTranslator;
    @Autowired
    private MessageHelperBean messageHelper;

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @ResponseBody
    public SubmitResult add(HttpServletRequest request, CommentForm form) {
        SubmitResult result = new SubmitResult();
        Locale locale = LocaleContextHolder.getLocale();
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        boolean success = false;
        String errorMessage = this.formTranslator.translateMessage(locale, "Wystapil_blad_podczas_dodawania_komentarza");
        Long commentId = null;
        if (this.commentService.canUserAddComment(form.getProcessId(), form.getActivityId(), userId)) {
            commentId = this.commentsService.add(form.getProcessId(), form.getActivityId(), form.getComment(), userId);
            success = commentId != null;
        } else {
            errorMessage = this.formTranslator.translateMessage(locale, "Brak_uprawnien_do_komentowania_zadan");
        }
        if (success) {
            result.setSuccess(true);
            result.setMessage(String.valueOf(commentId));
            request.setAttribute("auditSuccess", (Object)true);
        } else {
            result.setSuccess(false);
            result.setMessage(errorMessage);
        }
        return result;
    }

    @RequestMapping(value={"/get"}, method={RequestMethod.GET})
    @ResponseBody
    public List<CommentDto> get(HttpServletRequest request, @RequestParam(value="processId") String processId, @RequestParam(value="activityId") String activityId) {
        Locale locale = LocaleContextHolder.getLocale();
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        return this.commentsService.getAllForActivity(processId, activityId, userId, locale);
    }

    @RequestMapping(value={"exportToPdf"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> generate(HttpServletRequest request, @RequestParam(value="processId") String processId, @RequestParam(value="activityId") String activityId, @RequestParam(value="property") String property, @RequestParam(value="direction") String direction) {
        Locale locale = LocaleContextHolder.getLocale();
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        Sorter sorter = new Sorter("date", SortDirection.DESC);
        if (StringUtils.isNotBlank((String)property) && StringUtils.isNotBlank((String)direction)) {
            sorter.setProperty(property);
            if (direction.equals("ASC")) {
                sorter.setDirection(SortDirection.ASC);
            }
        }
        byte[] bytes = this.commentsService.exportToPdf(processId, activityId, userId, locale, sorter);
        HttpHeaders responseHeaders = this.buildExportToPdfHeaders(bytes);
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"exportToPdf"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> generate(CommentsForm form) {
        Locale locale = LocaleContextHolder.getLocale();
        byte[] bytes = this.commentsService.exportToPdf(form.getDtos(), locale);
        HttpHeaders responseHeaders = this.buildExportToPdfHeaders(bytes);
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/delete/{commentId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public SubmitResult delete(HttpServletRequest request, @PathVariable(value="commentId") Long commentId) {
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        boolean success = this.commentsService.delete(userId, commentId);
        SubmitResult result = new SubmitResult();
        result.setSuccess(success);
        if (success) {
            request.setAttribute("auditSuccess", (Object)true);
        }
        return result;
    }

    private HttpHeaders buildExportToPdfHeaders(byte[] bytes) {
        return this.buildPdfFileHeaders(bytes);
    }

    private HttpHeaders buildPdfFileHeaders(byte[] bytes) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.parseMediaType((String)PDF_CONTENT_TYPE));
        responseHeaders.setContentLength((long)ArrayUtils.getLength((Object)bytes));
        responseHeaders.setContentDispositionFormData("attachment", "eksport.pdf");
        return responseHeaders;
    }

    @ExceptionHandler(value={EmptyPropertyException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public SubmitResult handlePositionAlreadyExistException(EmptyPropertyException e) {
        SubmitResult result = new SubmitResult();
        result.setSuccess(false);
        result.setMessage(this.messageHelper.getMessage("Brak_wymaganego_pola") + ": " + e.getProperty());
        return result;
    }
}

