/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.servlet;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.audit.Audit;
import com.suncode.pwfl.audit.AuditParam;
import com.suncode.pwfl.audit.detail.AuditDetails;
import com.suncode.pwfl.audit.util.AuditServiceFactory;
import com.suncode.pwfl.audit.util.AuditTools;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.translation.TranslationSupport;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.TranslatorScope;
import com.suncode.pwfl.translation.Translators;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.webdocwf.dods.access.AccessRightException;

public class GetAuditDetails
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(GetAuditDetails.class);

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace("************************* GetAuditDetails Servlet ****************************");
        String userName = (String)request.getSession().getAttribute("username");
        JSONObject jsonAuditDetails = new JSONObject();
        boolean success = false;
        try {
            int rights = Authorization.checkRight((String)RightTreeBuilder.builder().system().admin().build(), (String)userName, (boolean)false, (boolean)false);
            if (rights != 0) {
                throw new AccessRightException("noRights");
            }
            Audit audit = this.getAudit(request);
            JSONObject jsonMainInfo = this.createMainInfo(audit);
            if (AuditTools.isDefinedAudit((String)audit.getAuditType())) {
                jsonAuditDetails.put("detailsInfo", (Object)this.getDefinedAudit(audit));
            } else {
                List translators = Translators.getAll((TranslatorScope)TranslatorScope.SERVER);
                jsonAuditDetails.put("detailsInfo", (Object)this.getNotDefinedAudit(audit, translators));
                jsonMainInfo.put("auditType", (Object)TranslationSupport.getMessage((String)audit.getAuditType(), (List)translators));
            }
            jsonAuditDetails.put("mainInfo", (Object)jsonMainInfo);
            success = true;
        }
        catch (AccessRightException e) {
            log.error(e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            PrintWriter printWriter = null;
            try {
                JSONObject jsonAnswer = new JSONObject();
                jsonAnswer.put("success", success);
                jsonAnswer.put("auditDetails", (Object)jsonAuditDetails);
                response.setContentType("application/json;charset=UTF-8");
                printWriter = response.getWriter();
                printWriter.print(jsonAnswer);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private Audit getAudit(HttpServletRequest request) {
        long auditId = Long.parseLong(request.getParameter("auditId"));
        return AuditServiceFactory.getAuditService().getAudit(Long.valueOf(auditId));
    }

    private JSONObject createMainInfo(Audit audit) throws JSONException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Locale locale = LocaleContextHolder.getLocale();
        JSONObject jsonMainInfo = new JSONObject();
        jsonMainInfo.put("userName", (Object)AuditTools.getUserRealName((String)audit.getUserId()));
        jsonMainInfo.put("auditType", (Object)MessageHelper.getOptionalMessage((String)audit.getAuditType(), (Locale)locale, (Object[])new Object[0]));
        jsonMainInfo.put("ipAddress", (Object)audit.getIpAddress());
        jsonMainInfo.put("threadId", (Object)audit.getThreadId());
        jsonMainInfo.put("auditStarted", (Object)dateFormat.format(new Date(audit.getAuditStarted())));
        jsonMainInfo.put("auditStopped", (Object)dateFormat.format(new Date(audit.getAuditStopped())));
        jsonMainInfo.put("auditDuration", (Object)AuditTools.getDurationValue((long)audit.getAuditDuration()));
        jsonMainInfo.put("auditSuccess", audit.isAuditSuccess());
        return jsonMainInfo;
    }

    public JSONArray getDefinedAudit(Audit audit) throws JSONException {
        Locale locale = LocaleContextHolder.getLocale();
        JSONArray jsonDetailsInfo = new JSONArray();
        AuditDetails auditDetails = new AuditDetails(AuditTypes.valueOf((String)audit.getAuditType()));
        List auditParams = auditDetails.decompose(audit.getAuditParams());
        for (AuditParam auditParam : auditParams) {
            JSONObject jsonAuditParam = new JSONObject();
            String paramTranslation = MessageHelper.getOptionalMessage((String)auditParam.getParamNameToTranslate(), (Locale)locale, (Object[])new Object[0]);
            if (paramTranslation.equals(auditParam.getParamNameToTranslate())) {
                log.warn("No translation for key {}", (Object)auditParam.getParamName());
                jsonAuditParam.put("paramName", (Object)MessageHelper.getOptionalMessage((String)auditParam.getParamName(), (Locale)locale, (Object[])new Object[0]));
            } else {
                jsonAuditParam.put("paramName", (Object)paramTranslation);
            }
            jsonAuditParam.put("paramValue", (Object)auditParam.getParamValue());
            jsonDetailsInfo.put((Object)jsonAuditParam);
        }
        return jsonDetailsInfo;
    }

    public JSONArray getNotDefinedAudit(Audit audit, List<Translator> translators) throws JSONException {
        String[] splittedParams;
        JSONArray jsonDetailsInfo = new JSONArray();
        for (String param : splittedParams = audit.getAuditParams().split("@AUDIT_PARAM@")) {
            if (!StringUtils.isNotBlank((CharSequence)param)) continue;
            String[] splitParam = param.split("=", -1);
            String key = splitParam[0];
            String value = AuditTools.joinTabValue((String[])splitParam, (String)"=");
            JSONObject jsonAuditParam = new JSONObject();
            jsonAuditParam.put("paramName", (Object)AuditTools.getParamTranslation((String)key, translators));
            jsonAuditParam.put("paramValue", (Object)AuditTools.getParamTranslation((String)value, translators));
            jsonDetailsInfo.put((Object)jsonAuditParam);
        }
        return jsonDetailsInfo;
    }
}

