/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.request;

import com.suncode.pwfl.audit.Audit;
import com.suncode.pwfl.audit.form.AuditCreatorHandler;
import com.suncode.pwfl.audit.request.AuditCreator;
import com.suncode.pwfl.audit.request.RequestParamsAnalyzer;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.audit.util.AuditUrls;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;

public class AuditCreator
implements AuditCreatorHandler {
    public Audit createAudit(HttpServletRequest request, AuditUrls auditUrl) {
        RequestParamsAnalyzer analyzer = new RequestParamsAnalyzer();
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        String userId = (String)session.getAttribute("username");
        switch (1.$SwitchMap$com$suncode$pwfl$audit$util$AuditUrls[auditUrl.ordinal()]) {
            case 1: {
                return new Audit(userId, AuditTypes.AUDIT_LOG_OUT);
            }
            case 2: {
                return new Audit(userId, AuditTypes.AUDIT_SAVE_ACTIVITY);
            }
            case 3: {
                return new Audit(userId, AuditTypes.AUDIT_ACCEPT_ACTIVITY);
            }
            case 4: {
                return new Audit(userId, AuditTypes.AUDIT_SEARCH_USER);
            }
            case 5: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_SYSTEM_PROTECTION);
            }
            case 6: 
            case 7: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_SYSTEM_PROTECTION);
            }
            case 8: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_POSITION);
            }
            case 9: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_POSITION);
            }
            case 10: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_ROLE_FROM_POSITION);
            }
            case 11: {
                return new Audit(userId, AuditTypes.AUDIT_SEARCH_POSITION);
            }
            case 12: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_ORG_UNIT);
            }
            case 13: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_ORG_UNIT);
            }
            case 14: {
                return new Audit(userId, AuditTypes.AUDIT_SEARCH_ORG_UNIT);
            }
            case 15: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_LINK);
            }
            case 16: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_DIRECTORY);
            }
            case 17: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_DIRECTORY);
            }
            case 18: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_DEVICE);
            }
            case 19: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_DEVICE);
            }
            case 20: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_LDAP_SERVER);
            }
            case 21: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_LDAP_SERVER);
            }
            case 22: {
                return new Audit(userId, AuditTypes.AUDIT_STATS);
            }
            case 23: {
                return new Audit(userId, AuditTypes.AUDIT_CHECKOUT_FILE_FROM_ARCHIVE);
            }
            case 24: {
                return new Audit(userId, AuditTypes.AUDIT_CHECKOUT_FILE_FROM_PROCESS);
            }
            case 25: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_NOTIFICATION);
            }
            case 26: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_NOTIFICATION);
            }
            case 27: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_DOCUMENT_TEMPLATE);
            }
            case 28: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_DOCUMENT_TEMPLATE);
            }
            case 29: {
                String xaction = request.getParameter("xaction");
                if (StringUtils.equals((CharSequence)xaction, (CharSequence)"globalConfig")) {
                    String value = request.getParameter("value");
                    if (StringUtils.equals((CharSequence)value, (CharSequence)"enable")) {
                        return new Audit(userId, AuditTypes.AUDIT_ENABLE_USER_NOTIFICATIONS);
                    }
                    if (StringUtils.equals((CharSequence)value, (CharSequence)"disable")) {
                        return new Audit(userId, AuditTypes.AUDIT_DISABLE_USER_NOTIFICATIONS);
                    }
                } else if (StringUtils.equals((CharSequence)xaction, (CharSequence)"destroy")) {
                    return new Audit(userId, AuditTypes.AUDIT_DELETE_USER_NOTIFICATIONS);
                }
                return null;
            }
            case 30: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_PROCESS_PROTECTION);
            }
            case 31: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_PROCESS_PROTECTION);
            }
            case 32: {
                return new Audit(userId, AuditTypes.AUDIT_UNINSTALL_MODULE);
            }
            case 33: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_COMMENT_TO_ACTIVITY);
            }
            case 34: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_COMMENT_FROM_ACTIVITY);
            }
            case 35: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_DOCUMENT_FROM_PROCESS);
            }
            case 36: {
                return new Audit(userId, AuditTypes.AUDIT_PROCESS_DETAILS);
            }
            case 37: {
                return new Audit(userId, AuditTypes.AUDIT_ACTIVITY_DETAILS);
            }
            case 38: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_DOCUMENT_FROM_ARCHIVE);
            }
            case 39: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_SEARCHED_DOCUMENTS);
            }
            case 40: {
                return new Audit(userId, AuditTypes.AUDIT_DEACTIVATE_USER);
            }
            case 41: {
                return new Audit(userId, AuditTypes.AUDIT_EDIT_DEACTIVATED_USER);
            }
            case 42: {
                return new Audit(userId, AuditTypes.AUDIT_EDIT_DOCUMENT_INDEXES);
            }
            case 43: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_PROCESSES);
            }
            case 44: {
                return new Audit(userId, AuditTypes.AUDIT_SUSPEND_ACTIVITY);
            }
            case 45: {
                return new Audit(userId, AuditTypes.AUDIT_ABORT_ACTIVITY);
            }
            case 46: {
                return new Audit(userId, AuditTypes.AUDIT_ACCEPT_MANY_ACTIVITIES);
            }
            case 47: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_DOCUMENT_VIEW);
            }
            case 48: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_DOCUMENT_VIEW);
            }
            case 49: {
                return new Audit(userId, AuditTypes.AUDIT_RUN_VIEW);
            }
            case 50: {
                return new Audit(userId, AuditTypes.AUDIT_LOAD_LICENSE);
            }
            case 51: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_LINK_INDEX);
            }
            case 52: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_LINK_INDEX);
            }
            case 53: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_LINK_CONNECTION);
            }
            case 54: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_LINK_CONNECTION);
            }
            case 55: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_LINK_PROTECTION);
            }
            case 56: {
                return new Audit(userId, AuditTypes.AUDIT_EDIT_LINK_PROTECTION);
            }
            case 57: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_LINK_PROTECTION);
            }
            case 58: {
                String change = request.getParameter("change");
                if (StringUtils.isNotBlank((CharSequence)change)) {
                    return new Audit(userId, AuditTypes.AUDIT_CHANGE_PASSWORD);
                }
                return null;
            }
            case 59: {
                String packageAction = request.getParameter("actionType");
                if (StringUtils.equals((CharSequence)packageAction, (CharSequence)"loadPackage")) {
                    return new Audit(userId, AuditTypes.AUDIT_LOAD_PACKAGE);
                }
                if (StringUtils.equals((CharSequence)packageAction, (CharSequence)"updatePackage")) {
                    return new Audit(userId, AuditTypes.AUDIT_UPDATE_PACKAGE);
                }
                if (StringUtils.equals((CharSequence)packageAction, (CharSequence)"closePackage")) {
                    return new Audit(userId, AuditTypes.AUDIT_CLOSE_PACKAGE);
                }
                if (StringUtils.equals((CharSequence)packageAction, (CharSequence)"clearPackage")) {
                    return new Audit(userId, AuditTypes.AUDIT_CLEAR_PACKAGE);
                }
                return null;
            }
            case 60: {
                String viewIdAddReport = request.getParameter("viewId");
                String sqlQueryAddReport = request.getParameter("sqlQuery");
                if (StringUtils.isNotBlank((CharSequence)viewIdAddReport)) {
                    return new Audit(userId, AuditTypes.AUDIT_ADD_VIEW_REPORT);
                }
                if (StringUtils.isNotBlank((CharSequence)sqlQueryAddReport)) {
                    return new Audit(userId, AuditTypes.AUDIT_ADD_SQL_QUERY_REPORT);
                }
                return null;
            }
            case 61: {
                String reportIdAddJasperReport = request.getParameter("reportId");
                if (StringUtils.isBlank((CharSequence)reportIdAddJasperReport)) {
                    return new Audit(userId, AuditTypes.AUDIT_ADD_JASPER_REPORT);
                }
                return new Audit(userId, AuditTypes.AUDIT_EDIT_JASPER_REPORT);
            }
            case 62: 
            case 63: {
                String viewIdRunReport = request.getParameter("viewId");
                String sqlQueryRunReport = request.getParameter("sqlQuery");
                String reportIdRunReport = request.getParameter("reportId");
                if (StringUtils.isNotBlank((CharSequence)viewIdRunReport)) {
                    return new Audit(userId, AuditTypes.AUDIT_RUN_VIEW_REPORT);
                }
                if (StringUtils.isNotBlank((CharSequence)sqlQueryRunReport)) {
                    return new Audit(userId, AuditTypes.AUDIT_RUN_SQL_QUERY_REPORT);
                }
                if (StringUtils.isNotBlank((CharSequence)reportIdRunReport)) {
                    return new Audit(userId, AuditTypes.AUDIT_RUN_JASPER_REPORT);
                }
                return null;
            }
            case 64: {
                return new Audit(userId, AuditTypes.AUDIT_RUN_SAVED_REPORT);
            }
            case 65: {
                return new Audit(userId, AuditTypes.AUDIT_FILTER_REPORT);
            }
            case 66: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_MODULE_RIGHT);
            }
            case 67: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_MODULE_RIGHT);
            }
            case 68: {
                if (request.getMethod().compareTo("POST") == 0) {
                    return new Audit(userId, AuditTypes.AUDIT_ADD_SCHEDULED_TASK);
                }
                return null;
            }
            case 69: {
                String scheduledTaskAction = request.getParameter("action");
                if (StringUtils.equals((CharSequence)scheduledTaskAction, (CharSequence)"remove")) {
                    return new Audit(userId, AuditTypes.AUDIT_DELETE_SCHEDULED_TASK);
                }
                if (StringUtils.equals((CharSequence)scheduledTaskAction, (CharSequence)"execute")) {
                    return new Audit(userId, AuditTypes.AUDIT_MANUAL_RUN_SCHEDULED_TASK);
                }
                if (StringUtils.equals((CharSequence)scheduledTaskAction, (CharSequence)"cancel")) {
                    return new Audit(userId, AuditTypes.AUDIT_STOP_SCHEDULED_TASK);
                }
                return null;
            }
            case 70: {
                Principal principal = request.getUserPrincipal();
                if (principal != null) {
                    String domainName = this.getAutoLoginAuditDomainName(principal);
                    String userName = request.getRemoteUser();
                    userId = new String(domainName + "/" + userName);
                    return new Audit(userId, AuditTypes.AUDIT_AUTO_LOG_IN);
                }
                return null;
            }
            case 71: {
                return new Audit(userId, AuditTypes.AUDIT_AUTO_LOG_OUT);
            }
            case 72: {
                return new Audit(userId, AuditTypes.AUDIT_ABORT_PROCESSES);
            }
        }
        return null;
    }

    private String getAutoLoginAuditDomainName(Principal principal) {
        String[] splittedPrincipalName = principal.getName().split("@");
        int dotPos = splittedPrincipalName[1].indexOf(".");
        if (dotPos != -1) {
            return StringUtils.lowerCase((String)splittedPrincipalName[1].substring(0, dotPos));
        }
        return StringUtils.lowerCase((String)splittedPrincipalName[1]);
    }
}

