/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.object.ProcessDef;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.audit.util.AuditTools;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class UpsertProcessProtectionFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(UpsertProcessProtectionFormatter.class);
    private final String userIdKey = "userName";
    private final String isGroupKey = "isGroup";
    private final String processDefIdKey = "procTypeId";
    private final String viewProcessKey = "viewProcess";
    private final String createProcessKey = "createProcess";
    private final String deleteProcessKey = "deleteProcess";
    private final String statsProcessKey = "statsProcess";
    private final String historyProcessKey = "historyProcess";
    private final String historyCommentsProcessKey = "historyCommentsProcess";
    private final String processDashboardAccessProcessKey = "processDashboardAccessProcess";
    private final String processVisibilityProcessKey = "processVisibilityProcess";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            Locale locale = LocaleContextHolder.getLocale();
            String userId = map.get("userName");
            String isGroup = map.get("isGroup");
            String processDefId = map.get("procTypeId");
            String viewProcess = map.get("viewProcess");
            String createProcess = map.get("createProcess");
            String deleteProcess = map.get("deleteProcess");
            String statsProcess = map.get("statsProcess");
            String historyProcess = map.get("historyProcess");
            String historyCommentsProcess = map.get("historyCommentsProcess");
            String processDashboardAccessProcess = map.get("processDashboardAccessProcess");
            String processVisibilityProcess = map.get("processVisibilityProcess");
            if (StringUtils.isBlank((String)isGroup)) {
                isGroup = "FALSE";
            }
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), this.getProcessName(processDefId));
            if (Boolean.parseBoolean(isGroup)) {
                formattedMap.put(AuditParamsNames.USER_NAME.toString(), userId);
            } else {
                formattedMap.put(AuditParamsNames.USER_NAME.toString(), AuditTools.getUserRealName((String)userId));
            }
            formattedMap.put(AuditParamsNames.IS_GROUP.toString(), this.translateBooleanValue(isGroup, locale));
            formattedMap.put(AuditParamsNames.VIEW_PROCESS.toString(), this.translateBooleanValue(viewProcess, locale));
            formattedMap.put(AuditParamsNames.CREATE_PROCESS.toString(), this.translateBooleanValue(createProcess, locale));
            formattedMap.put(AuditParamsNames.DELETE_PROCESS.toString(), this.translateBooleanValue(deleteProcess, locale));
            formattedMap.put(AuditParamsNames.PROCESS_STATS.toString(), this.translateBooleanValue(statsProcess, locale));
            formattedMap.put(AuditParamsNames.ALL_PROCESSES_HISTORY.toString(), this.translateBooleanValue(historyProcess, locale));
            formattedMap.put(AuditParamsNames.HISTORY_COMMENTS.toString(), this.translateBooleanValue(historyCommentsProcess, locale));
            formattedMap.put(AuditParamsNames.PROCESS_DASHBOARD_ACCESS.toString(), this.translateBooleanValue(processDashboardAccessProcess, locale));
            formattedMap.put(AuditParamsNames.PROCESS_VISIBILITY.toString(), this.translateBooleanValue(processVisibilityProcess, locale));
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String getProcessName(String processDefId) {
        ProcessDef processDef = new ProcessDef(processDefId);
        return processDef.getProcessName();
    }
}

