/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.plusmpm.i18n.I18Nxpdl;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class UpsertNotificationFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(UpsertNotificationFormatter.class);
    private final String nameKey = "name";
    private final String subjectKey = "subject";
    private final String processDefIdKey = "procDefId";
    private final String pathKey = "path";
    private final String conditionKey = "condition";
    private final String valueKey = "value";
    private final String activityDefIdKey = "activity";
    private final String recipientTypeKey = "recipientType";
    private final String recipientKey = "recipient";
    private final String recipientPerformerKey = "recipientPerformer";
    private final String dontSendOnWeekendsKey = "dontSendOnWeekends";
    private final String dontSendOnHolidaysAndDaysOffKey = "dontSendOnHolidaysAndDaysOff";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String name = map.get("name");
            String subject = map.get("subject");
            String processDefId = map.get("procDefId");
            String path = map.get("path");
            String condition = map.get("condition");
            String value = map.get("value");
            String activityDefId = map.get("activity");
            String recipientPerformer = map.get("recipientPerformer");
            String dontSendOnWeekends = map.get("dontSendOnWeekends");
            String dontSendOnHolidaysAndDaysOff = map.get("dontSendOnHolidaysAndDaysOff");
            Locale locale = LocaleContextHolder.getLocale();
            I18Nxpdl xpdl = new I18Nxpdl(locale);
            String processName = this.getProcessName(processDefId, xpdl);
            boolean isCreateAction = map.containsKey("recipientType") && map.containsKey("recipient");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), processName);
            formattedMap.put(AuditParamsNames.NOTIFICATION_NAME.toString(), name);
            formattedMap.put(AuditParamsNames.NOTIFICATION_SUBJECT.toString(), subject);
            formattedMap.put(AuditParamsNames.NOTIFICATION_PATH.toString(), path);
            formattedMap.put(AuditParamsNames.NOTIFICATION_CONDITION.toString(), this.translateCondition(condition, locale));
            formattedMap.put(AuditParamsNames.NOTIFICATION_VALUE.toString(), value);
            if (isCreateAction) {
                String activityName = this.getActivityName(processDefId, activityDefId, xpdl);
                formattedMap.put(AuditParamsNames.ACTIVITY_NAME.toString(), activityName);
                String recipientType = map.get("recipientType");
                String recipient = map.get("recipient");
                formattedMap.put(AuditParamsNames.RECIPIENT_TYPE.toString(), this.translateRecipientType(recipientType, locale));
                formattedMap.put(AuditParamsNames.RECIPIENT.toString(), recipient);
            }
            formattedMap.put(AuditParamsNames.IS_RECIPIENT_PERFORMER.toString(), this.translateCheckboxValue(recipientPerformer, isCreateAction, locale));
            formattedMap.put(AuditParamsNames.DONT_SEND_ON_WEEKENDS.toString(), this.translateCheckboxValue(dontSendOnWeekends, isCreateAction, locale));
            formattedMap.put(AuditParamsNames.DONT_SENT_ON_HOLIDAYS_AND_DAYS_OFF.toString(), this.translateCheckboxValue(dontSendOnHolidaysAndDaysOff, isCreateAction, locale));
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    protected String translateCondition(String condition, Locale locale) {
        if (StringUtils.isNotBlank((String)condition) && condition.split(";").length > 1) {
            String[] conditions = condition.split(";");
            return this.translateConditionName(conditions[0], locale) + " > " + this.translateConditionName(conditions[1], locale);
        }
        return this.translateConditionName(condition, locale);
    }

    private String translateConditionName(String condition, Locale locale) {
        if (StringUtils.equals((String)condition, (String)"create")) {
            return MessageHelper.getMessage((String)"Utworzenie", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((String)condition, (String)"end")) {
            return MessageHelper.getMessage((String)"Zakonczenie", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((String)condition, (String)"deadline")) {
            return MessageHelper.getMessage((String)"Przekroczenie_podanego_terminu", (Locale)locale, (Object[])new Object[0]);
        }
        return condition;
    }

    private String translateRecipientType(String recipientType, Locale locale) {
        if (StringUtils.equals((String)recipientType, (String)"user")) {
            return MessageHelper.getMessage((String)"Uzytkownik", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((String)recipientType, (String)"group")) {
            return MessageHelper.getMessage((String)"Grupa", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((String)recipientType, (String)"participant")) {
            return MessageHelper.getMessage((String)"Wykonawca", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((String)recipientType, (String)"allparticipants")) {
            return MessageHelper.getMessage((String)"Wykonawcy", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((String)recipientType, (String)"position")) {
            return MessageHelper.getMessage((String)"Stanowisko", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((String)recipientType, (String)"participanthigherposition")) {
            return MessageHelper.getMessage((String)"Przelozony", (Locale)locale, (Object[])new Object[0]);
        }
        return recipientType;
    }

    private String handleEmptyCheckBoxValue(String value, boolean isCreateAction) {
        if (StringUtils.isBlank((String)value)) {
            if (isCreateAction) {
                return "FALSE";
            }
            return "OFF";
        }
        return value;
    }

    private String translateCheckboxValue(String value, boolean isCreateAction, Locale locale) {
        if (value != null && value.split(";").length > 1) {
            String[] changedValues = value.split(";");
            String oldValue = this.handleEmptyCheckBoxValue(changedValues[0], isCreateAction);
            String newValue = this.handleEmptyCheckBoxValue(changedValues[1], isCreateAction);
            return MessageHelper.getMessage((String)"AUDIT_PARAM_VALUE_".concat(oldValue.toUpperCase()), (Locale)locale, (Object[])new Object[0]) + " > " + MessageHelper.getMessage((String)"AUDIT_PARAM_VALUE_".concat(newValue.toUpperCase()), (Locale)locale, (Object[])new Object[0]);
        }
        return MessageHelper.getMessage((String)"AUDIT_PARAM_VALUE_".concat(this.handleEmptyCheckBoxValue(value, isCreateAction).toUpperCase()), (Locale)locale, (Object[])new Object[0]);
    }
}

