/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.support.MessageSourceAccessor;

public class StatsFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(StatsFormatter.class);
    private final String startDateKey = "startDate";
    private final String endDateKey = "endDate";
    private final String statTypeKey = "statType";
    private final String userStatDayTypeKey = "userStatDayType";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        MessageSourceAccessor messageSource = MessageHelper.getInstance().getMessageSourceAccessor();
        try {
            String statType = map.get("statType");
            String userStatDayType = map.get("userStatDayType");
            boolean bUseUserStatDayType = false;
            if (!StringUtils.isBlank((String)statType)) {
                if (statType.equalsIgnoreCase("userStat")) {
                    statType = messageSource.getMessage("Statystyka_uzytkownikow");
                } else if (statType.equalsIgnoreCase("userStatPerProcess")) {
                    statType = messageSource.getMessage("Statystyka_uzytkownikow_w_podziale_na_procesy");
                } else if (statType.equalsIgnoreCase("userStatDay")) {
                    statType = messageSource.getMessage("Statystyka_okresowa_uzytkownikow");
                    bUseUserStatDayType = true;
                } else if (statType.equalsIgnoreCase("userStatDayPerProc")) {
                    statType = messageSource.getMessage("Statystyka_okresowa_uzytkownikow_w_przedziale_na_procesy_i_zadania");
                } else if (statType.equalsIgnoreCase("procStat")) {
                    statType = messageSource.getMessage("Statystyka_procesow");
                } else if (statType.equalsIgnoreCase("procStatPerTask")) {
                    statType = messageSource.getMessage("Statystyka_zadan_w_procesach");
                } else if (statType.equalsIgnoreCase("fullStat")) {
                    statType = messageSource.getMessage("Pelna_statystyka");
                }
            }
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.DATE_FROM.toString(), map.get("startDate"));
            formattedMap.put(AuditParamsNames.DATE_TO.toString(), map.get("endDate"));
            formattedMap.put(AuditParamsNames.STAT_TYPE_NAME.toString(), statType);
            if (bUseUserStatDayType && !StringUtils.isBlank((String)userStatDayType)) {
                if (userStatDayType.equalsIgnoreCase("day")) {
                    userStatDayType = messageSource.getMessage("Dzienna");
                } else if (userStatDayType.equalsIgnoreCase("week")) {
                    userStatDayType = messageSource.getMessage("Tygodniowa");
                } else if (userStatDayType.equalsIgnoreCase("month")) {
                    userStatDayType = messageSource.getMessage("Miesieczna");
                } else if (userStatDayType.equalsIgnoreCase("year")) {
                    userStatDayType = messageSource.getMessage("Roczna");
                }
                formattedMap.put(AuditParamsNames.USER_STAT_DAY_TYPE_NAME.toString(), userStatDayType);
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

