/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class ViewCalendarFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(ViewCalendarFormatter.class);
    private final String idKey = "id";
    private final String nameKey = "name";
    private final String colorKey = "color";
    private final String viewIdKey = "viewId";
    private final String variableIdStartDateTimeKey = "variableIdStartDateTime";
    private final String variableIdEndDateTimeKey = "variableIdEndDateTime";
    private final String durationMinutesKey = "durationMinutes";
    private final String allDayKey = "allDay";
    private final String nameTemplateKey = "nameTemplate";
    private final String nameTemplateMonthKey = "nameTemplateMonth";
    private final String nameTemplateWeekKey = "nameTemplateWeek";
    private final String nameTemplateDayKey = "nameTemplateDay";
    private final String descriptionTemplateKey = "descriptionTemplate";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String id = map.get("id");
            String name = map.get("name");
            String color = map.get("color");
            String viewId = map.get("viewId");
            String variableIdStartDateTime = map.get("variableIdStartDateTime");
            String variableIdEndDateTime = map.get("variableIdEndDateTime");
            String durationMinutes = map.get("durationMinutes");
            String allDay = map.get("allDay");
            String nameTemplate = map.get("nameTemplate");
            String nameTemplateMonth = map.get("nameTemplateMonth");
            String nameTemplateWeek = map.get("nameTemplateWeek");
            String nameTemplateDay = map.get("nameTemplateDay");
            String descriptionTemplate = map.get("descriptionTemplate");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                formattedMap.put(AuditParamsNames.CALENDAR_ID.name(), this.formatTextValueChange(id));
            }
            if (StringUtils.isNotBlank((CharSequence)name)) {
                formattedMap.put(AuditParamsNames.CALENDAR_NAME.name(), this.formatTextValueChange(name));
            }
            if (StringUtils.isNotBlank((CharSequence)color)) {
                formattedMap.put(AuditParamsNames.CALENDAR_COLOR.name(), this.formatTextValueChange(color));
            }
            if (StringUtils.isNotBlank((CharSequence)viewId)) {
                formattedMap.put(AuditParamsNames.CALENDAR_VIEW_ID.name(), this.formatTextValueChange(viewId));
            }
            if (StringUtils.isNotBlank((CharSequence)variableIdStartDateTime)) {
                formattedMap.put(AuditParamsNames.CALENDAR_VARIABLE_ID_START_DATE_TIME.name(), this.formatTextValueChange(variableIdStartDateTime));
            }
            if (StringUtils.isNotBlank((CharSequence)variableIdEndDateTime)) {
                formattedMap.put(AuditParamsNames.CALENDAR_VARIABLE_ID_END_DATE_TIME.name(), this.formatTextValueChange(variableIdEndDateTime));
            }
            if (StringUtils.isNotBlank((CharSequence)durationMinutes)) {
                formattedMap.put(AuditParamsNames.CALENDAR_DURATION_MINUTES.name(), this.formatTextValueChange(durationMinutes));
            }
            if (StringUtils.isNotBlank((CharSequence)allDay)) {
                formattedMap.put(AuditParamsNames.CALENDAR_ALL_DAY.name(), this.translateBooleanValue(allDay, LocaleContextHolder.getLocale()));
            }
            if (StringUtils.isNotBlank((CharSequence)nameTemplate)) {
                formattedMap.put(AuditParamsNames.CALENDAR_NAME_TEMPLATE.name(), this.formatTextValueChange(nameTemplate));
            }
            if (StringUtils.isNotBlank((CharSequence)nameTemplateMonth)) {
                formattedMap.put(AuditParamsNames.CALENDAR_NAME_TEMPLATE_MONTH.name(), this.formatTextValueChange(nameTemplateMonth));
            }
            if (StringUtils.isNotBlank((CharSequence)nameTemplateWeek)) {
                formattedMap.put(AuditParamsNames.CALENDAR_NAME_TEMPLATE_WEEK.name(), this.formatTextValueChange(nameTemplateWeek));
            }
            if (StringUtils.isNotBlank((CharSequence)nameTemplateDay)) {
                formattedMap.put(AuditParamsNames.CALENDAR_NAME_TEMPLATE_DAY.name(), this.formatTextValueChange(nameTemplateDay));
            }
            if (StringUtils.isNotBlank((CharSequence)descriptionTemplate)) {
                formattedMap.put(AuditParamsNames.CALENDAR_DESCRIPTION_TEMPLATE.name(), this.formatTextValueChange(descriptionTemplate));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

