/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.plusmpm.i18n.I18Nxpdl;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.search.SortDirection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class OpenActivitiesFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(OpenActivitiesFormatter.class);
    private final String stateKey = "state";
    private final String processDefinitionIdsKey = "processDefinitionIds";
    private final String sortByKey = "sortBy";
    private final String sortDirectionKey = "sortDirection";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String state = map.get("state");
            List<String> processDefinitionIds = Arrays.asList(map.get("processDefinitionIds").split(", "));
            String sortBy = map.get("sortBy");
            SortDirection sortDirection = SortDirection.valueOf((String)map.get("sortDirection"));
            Locale locale = LocaleContextHolder.getLocale();
            I18Nxpdl xpdl = new I18Nxpdl(locale);
            String processTypes = processDefinitionIds.stream().map(processDefId -> this.getProcessName((String)processDefId, xpdl)).collect(Collectors.joining(", "));
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.ACTIVITY_STATE.name(), MessageHelper.getMessage((String)("ActivityState_" + state.toUpperCase())));
            formattedMap.put(AuditParamsNames.PROCESS_TYPES.name(), processTypes);
            formattedMap.put(AuditParamsNames.SORT_BY.name(), sortBy);
            formattedMap.put(AuditParamsNames.SORT_DIRECTION.name(), sortDirection.equals((Object)SortDirection.ASC) ? MessageHelper.getMessage((String)"Rosnaco") : MessageHelper.getMessage((String)"Malejaco"));
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

