/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.audit.util.AuditTools;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DeleteSystemProtectionFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(DeleteSystemProtectionFormatter.class);
    private final String userIdKey = "userId";
    private final String isGroupKey = "isGroup";
    private final String moduleIdKey = "moduleId";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String userId = map.get("userId");
            String isGroup = map.get("isGroup");
            String moduleId = map.get("moduleId");
            if (StringUtils.isBlank((String)isGroup)) {
                isGroup = "FALSE";
            }
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.USER_NAME.toString(), AuditTools.getUserRealName(userId));
            formattedMap.put(AuditParamsNames.IS_GROUP.toString(), MessageHelper.getOptionalMessage((String)"AUDIT_PARAM_VALUE_".concat(isGroup.toUpperCase())));
            if (StringUtils.isNotBlank((String)moduleId)) {
                formattedMap.put(AuditParamsNames.SYSTEM_MODULE_NAME.toString(), moduleId);
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

