/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSearchFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(UserSearchFormatter.class);
    private final String usernameKey = "username";
    private final String firstNameKey = "firstName";
    private final String lastNameKey = "lastName";
    private final String groupNameKey = "groupName";
    private final String positionKey = "position";
    private final String positionSymbolKey = "positionSymbol";
    private final String emailKey = "email";
    private final String numberKey = "number";
    private final String activeKey = "active";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String username = map.get("username");
            String firstName = map.get("firstName");
            String lastName = map.get("lastName");
            String groupName = map.get("groupName");
            String position = map.get("position");
            String positionSymbol = map.get("positionSymbol");
            String email = map.get("email");
            String number = map.get("number");
            String active = map.get("active");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.USERNAME.name(), username);
            formattedMap.put(AuditParamsNames.USERFIRSTNAME.name(), firstName);
            formattedMap.put(AuditParamsNames.USERLASTNAME.name(), lastName);
            formattedMap.put(AuditParamsNames.USERGROUPNAME.name(), groupName);
            formattedMap.put(AuditParamsNames.POSITION_NAME.name(), position);
            formattedMap.put(AuditParamsNames.POSITIONSYMBOL.name(), positionSymbol);
            formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_EMAIL.name(), email);
            formattedMap.put(AuditParamsNames.USERNUMBER.name(), number);
            formattedMap.put(AuditParamsNames.ACTIVE.name(), Boolean.parseBoolean(active) ? MessageHelper.getMessage((String)"Tak") : MessageHelper.getMessage((String)"Nie"));
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

