/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProcessFieldsFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(DefaultProcessFieldsFormatter.class);
    private final String processDefIdKey = "processDefId";
    private final String activityDefIdKey = "activityDefId";
    private final String savedKey = "saved";
    private final String updatedKey = "updated";
    private final String deletedKey = "deleted";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String processDefId = map.get("processDefId");
            String activityDefId = map.get("activityDefId");
            String saved = map.get("saved");
            String updated = map.get("updated");
            String deleted = map.get("deleted");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.PROCESS_DEF_ID.toString(), processDefId);
            if (StringUtils.isNotBlank((CharSequence)activityDefId)) {
                formattedMap.put(AuditParamsNames.ACTIVITY_DEF_ID.toString(), activityDefId);
            }
            if (StringUtils.isNotBlank((CharSequence)saved)) {
                formattedMap.put(AuditParamsNames.NEW.toString(), saved);
            }
            if (StringUtils.isNotBlank((CharSequence)updated)) {
                formattedMap.put(AuditParamsNames.UPDATED.toString(), updated);
            }
            if (StringUtils.isNotBlank((CharSequence)deleted)) {
                formattedMap.put(AuditParamsNames.DELETED.toString(), deleted);
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

