/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.audit.util.AuditTools;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class UpsertDocClassProtectionFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(UpsertDocClassProtectionFormatter.class);
    private final String userIdKey = "userName";
    private final String isGroupKey = "isGroup";
    private final String documentClassIdKey = "docclassId";
    private final String rightLevelKey = "rightLevel";
    private final String printingRightKey = "printingRight";
    private final String conditionsLogicalConnectionKey = "conditionsLogicalConnection";
    private final String addDocumentInArchiveKey = "addDocumentInArchive";
    private final String addDocumentInProcessKey = "addDocumentInProcess";
    private final String documentDetachKey = "documentDetach";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String userId = map.get("userName");
            String isGroup = map.get("isGroup");
            String documentClassId = map.get("docclassId");
            String rightLevel = map.get("rightLevel");
            String addDocumentInArchive = map.get("addDocumentInArchive");
            String addDocumentInProcess = map.get("addDocumentInProcess");
            String documentDetach = map.get("documentDetach");
            String printingRight = map.get("printingRight");
            String conditionsLogicalConnection = map.get("conditionsLogicalConnection");
            Locale locale = LocaleContextHolder.getLocale();
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.USER_NAME.toString(), AuditTools.getUserRealName((String)userId));
            formattedMap.put(AuditParamsNames.IS_GROUP.toString(), this.translateBooleanValue(isGroup, locale));
            DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
            DocumentClass documentClass = (DocumentClass)documentClassService.get((Serializable)Long.valueOf(documentClassId));
            if (documentClass != null) {
                formattedMap.put(AuditParamsNames.DOC_CLASS_NAME.toString(), documentClass.getName());
            } else {
                formattedMap.put(AuditParamsNames.DOC_CLASS_ID.toString(), documentClassId);
            }
            formattedMap.put(AuditParamsNames.RIGHT_LEVEL.toString(), this.translateRightLevel(rightLevel, locale));
            formattedMap.put(AuditParamsNames.ADD_DOCUMENT_IN_ARCHIVE.toString(), this.translateBooleanValue(addDocumentInArchive, locale));
            formattedMap.put(AuditParamsNames.ADD_DOCUMENT_IN_PROCESS.toString(), this.translateBooleanValue(addDocumentInProcess, locale));
            formattedMap.put(AuditParamsNames.PRINT_DOCUMENT.toString(), this.translateBooleanValue(printingRight, locale));
            formattedMap.put(AuditParamsNames.LOGICALCONNECTION.toString(), conditionsLogicalConnection);
            formattedMap.put(AuditParamsNames.DOCUMENT_DETACH.toString(), this.translateDocumentDetachProtectionType(documentDetach, locale));
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

