/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.util.SpringContext;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchLinkFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(SearchLinkFormatter.class);
    private final String linkIdKey = "lines[0].varValue";
    private final String searchedDocumentClassesKey = "searchedDocumentClasses";
    private final String dateStartKey = "dateStart";
    private final String dateFinishKey = "dateFinish";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String linkId = map.get("lines[0].varValue");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            Link link = ((LinkService)SpringContext.getBean(LinkService.class)).getLink(Long.valueOf(linkId), new String[0]);
            if (link != null) {
                formattedMap.put(AuditParamsNames.LINK_NAME.toString(), link.getName());
            } else {
                formattedMap.put(AuditParamsNames.LINK_ID.toString(), linkId);
            }
            if (StringUtils.isNotBlank((CharSequence)map.get("searchedDocumentClasses"))) {
                formattedMap.put(AuditParamsNames.DOC_CLASS_ID.toString(), map.get("searchedDocumentClasses"));
            }
            if (StringUtils.isNotBlank((CharSequence)map.get("dateStart"))) {
                formattedMap.put(AuditParamsNames.DATE_START.toString(), map.get("dateStart"));
            }
            if (StringUtils.isNotBlank((CharSequence)map.get("dateFinish"))) {
                formattedMap.put(AuditParamsNames.DATE_FINISH.toString(), map.get("dateFinish"));
            }
            map.remove("lines[0].varValue");
            map.remove("searchedDocumentClasses");
            map.remove("dateStart");
            map.remove("dateFinish");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (StringUtils.isBlank((CharSequence)entry.getValue()) || "null".equals(entry.getValue())) continue;
                formattedMap.put(entry.getKey(), entry.getValue());
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

