/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.calendar.process.api.ProcessCalendarService;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.SpringContext;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessCalendarShareFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(ProcessCalendarShareFormatter.class);
    private final String idKey = "id";
    private final String calendarIdKey = "calendarId";
    private final String calendarNameKey = "calendarName";
    private final String userNameKey = "userName";
    private final String groupNameKey = "groupName";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String id = map.get("id");
            String calendarId = map.get("calendarId");
            String calendarName = map.get("calendarName");
            String userName = map.get("userName");
            String groupName = map.get("groupName");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                formattedMap.put(AuditParamsNames.CALENDAR_SHARE_ID.name(), this.formatTextValueChange(id));
            }
            if (StringUtils.isNotBlank((CharSequence)calendarId)) {
                formattedMap.put(AuditParamsNames.CALENDAR_SHARE_CALENDAR_ID.name(), this.formatTextValueChange(calendarId));
            }
            if (StringUtils.isNotBlank((CharSequence)calendarName)) {
                formattedMap.put(AuditParamsNames.CALENDAR_EVENT_CALENDAR.name(), this.getCalendarName(calendarId, calendarName));
            }
            if (StringUtils.isNotBlank((CharSequence)userName)) {
                formattedMap.put(AuditParamsNames.CALENDAR_SHARE_USERNAME.name(), this.formatTextValueChange(userName));
            }
            if (StringUtils.isNotBlank((CharSequence)groupName)) {
                formattedMap.put(AuditParamsNames.CALENDAR_SHARE_GROUPNAME.name(), this.formatTextValueChange(groupName));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String getCalendarName(String calendarId, String calendarName) {
        try {
            ProcessCalendarService processCalendarService = (ProcessCalendarService)SpringContext.getBean(ProcessCalendarService.class);
            String translatedCalendarName = processCalendarService.getCalendarTranslation(Long.valueOf(calendarId), TranslatedFieldType.NAME);
            return StringUtils.isNotBlank((CharSequence)translatedCalendarName) ? translatedCalendarName : calendarName;
        }
        catch (Exception ignored) {
            return calendarName;
        }
    }
}

