/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.audit.util.AuditTools;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class DeleteDocClassProtectionFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(DeleteDocClassProtectionFormatter.class);
    private final String userIdKey = "userId";
    private final String isGroupKey = "isGroup";
    private final String documentClassIdKey = "docclassId";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String userId = map.get("userId");
            String isGroup = map.get("isGroup");
            String documentClassId = map.get("docclassId");
            if (StringUtils.isBlank((CharSequence)isGroup)) {
                isGroup = "FALSE";
            }
            Locale locale = LocaleContextHolder.getLocale();
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.USER_NAME.toString(), AuditTools.getUserRealName((String)userId));
            formattedMap.put(AuditParamsNames.IS_GROUP.toString(), MessageHelper.getOptionalMessage((String)"AUDIT_PARAM_VALUE_".concat(isGroup.toUpperCase()), (Locale)locale, (Object[])new Object[0]));
            DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
            DocumentClass documentClass = (DocumentClass)documentClassService.get((Serializable)Long.valueOf(documentClassId));
            if (documentClass != null) {
                formattedMap.put(AuditParamsNames.DOC_CLASS_NAME.toString(), documentClass.getName());
            } else {
                formattedMap.put(AuditParamsNames.DOC_CLASS_ID.toString(), documentClassId);
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

