/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseLinkFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(BaseLinkFormatter.class);
    private final String linkIdKey = "linkId";
    private final String linkNameKey = "linkName";
    private final String linkDescrKey = "linkDescr";
    private final String iconKey = "icon";
    private final String iconColorKey = "iconColor";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String linkId = map.get("linkId");
            String linkName = map.get("linkName");
            String linkDescr = map.get("linkDescr");
            String iconName = map.get("icon");
            String iconColor = map.get("iconColor");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.LINK_ID.toString(), linkId);
            formattedMap.put(AuditParamsNames.LINK_NAME.toString(), this.getCustomName(linkName));
            formattedMap.put(AuditParamsNames.LINKDESCR.toString(), this.getCustomName(linkDescr));
            formattedMap.put(AuditParamsNames.ICON.name(), this.getCustomName(iconName));
            formattedMap.put(AuditParamsNames.ICON_COLOR.name(), this.getCustomName(iconColor));
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

