/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.plusmpm.i18n.I18Nxpdl;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class AddReplacementVariableFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(AddReplacementVariableFormatter.class);
    private final String processDefIdKey = "processDefId";
    private final String variableNameKey = "variableName";
    private final String userInfoTypeKey = "userInfoType";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String processDefId = map.get("processDefId");
            String variableName = map.get("variableName");
            String userInfoType = map.get("userInfoType");
            I18Nxpdl xpdl = new I18Nxpdl(LocaleContextHolder.getLocale());
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), this.getProcessName(processDefId, xpdl));
            formattedMap.put(AuditParamsNames.VARIABLE_NAME.toString(), this.translateReplacementVariableName(processDefId, variableName));
            formattedMap.put(AuditParamsNames.USER_INFO_TYPE.toString(), this.translateUserInfoType(userInfoType));
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

