/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.parser.wrapper.XpdlKey;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.audit.util.AuditTools;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class AddOrDeleteDelegationFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(AddOrDeleteDelegationFormatter.class);
    private final String processDefIdKey = "processName";
    private final String participantIdKey = "participantName";
    private final String userIdKey = "usernameId";
    private final String delegatedUserIdKey = "delegatedUserName";
    private final String startDateKey = "startDate";
    private final String finishDateKey = "finishDate";
    private final String userDelegationIdKey = "userDelegationId";
    private final String addingTypeKey = "addingType";
    private final String errorMessage = "ERROR_MESSAGE";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String processDefId = map.get("processName");
            String participantId = map.get("participantName");
            String userId = map.get("usernameId");
            String delegatedUserId = map.get("delegatedUserName");
            Locale locale = LocaleContextHolder.getLocale();
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (map.containsKey("userDelegationId")) {
                formattedMap.put(AuditParamsNames.DELEGATIONID.toString(), map.get("userDelegationId"));
            }
            if (map.containsKey("ERROR_MESSAGE")) {
                try {
                    formattedMap.put(AuditParamsNames.ERROR_MESSAGE.toString(), MessageHelper.getMessage((String)map.get("ERROR_MESSAGE")));
                }
                catch (Exception ex) {
                    formattedMap.put(AuditParamsNames.ERROR_MESSAGE.toString(), map.get("ERROR_MESSAGE"));
                }
            }
            formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), this.getProcessName(processDefId, locale));
            formattedMap.put(AuditParamsNames.PARTICIPANT_NAME.toString(), this.getParticipantName(participantId, processDefId, locale));
            formattedMap.put(AuditParamsNames.USER_NAME.toString(), AuditTools.getUserRealName((String)userId));
            formattedMap.put(AuditParamsNames.DELEGATED_USER_NAME.toString(), AuditTools.getUserRealName((String)delegatedUserId));
            formattedMap.put(AuditParamsNames.DATE_FROM.toString(), map.get("startDate"));
            formattedMap.put(AuditParamsNames.DATE_TO.toString(), map.get("finishDate"));
            if (map.containsKey("addingType")) {
                formattedMap.put(AuditParamsNames.DELEGATION_ADDING_TYPE.toString(), MessageHelper.getMessage((String)map.get("addingType")));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String getProcessName(String processDefId, Locale locale) {
        if (StringUtils.equals((CharSequence)processDefId, (CharSequence)"*")) {
            return MessageHelper.getMessage((String)"Wszystkie", (Locale)locale, (Object[])new Object[0]);
        }
        I18Nxpdl i18Nxpdl = new I18Nxpdl(locale);
        return this.getProcessName(processDefId, i18Nxpdl);
    }

    private String getParticipantName(String participantId, String processDefId, Locale locale) {
        if (StringUtils.equals((CharSequence)participantId, (CharSequence)"*")) {
            return MessageHelper.getMessage((String)"Wszyscy", (Locale)locale, (Object[])new Object[0]);
        }
        I18Nxpdl xpdl = new I18Nxpdl(locale);
        String packageId = XpdlPackageManager.getInstance().getPackageIdByProcessDefinitionId(processDefId);
        if (StringUtils.isBlank((CharSequence)packageId)) {
            return "";
        }
        return xpdl.getString(XpdlKey.forPackage((String)packageId).forProcess(processDefId).forParticipant(participantId).getKey(), XpdlKey.forPackage((String)packageId).forParticipant(participantId).getKey());
    }
}

