/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.plusmpm.database.plugin.PluginConfiguration;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.audit.util.AuditTools;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.persistence.plugins.PluginConfigurationDAO;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class AddDeleteModuleRightFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(AddDeleteModuleRightFormatter.class);
    private final String userIdKey = "resource";
    private final String isGroupKey = "group";
    private final String pluginIdKey = "pluginId";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String userId = map.get("resource");
            String isGroup = map.get("group");
            String pluginId = map.get("pluginId");
            if (StringUtils.isBlank((String)isGroup)) {
                isGroup = "FALSE";
            }
            Locale locale = LocaleContextHolder.getLocale();
            PluginConfiguration plugin = PluginConfigurationDAO.getPlugin((String)pluginId);
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.USER_NAME.toString(), AuditTools.getUserRealName((String)userId));
            formattedMap.put(AuditParamsNames.IS_GROUP.toString(), MessageHelper.getOptionalMessage((String)"AUDIT_PARAM_VALUE_".concat(isGroup.toUpperCase()), (Locale)locale, (Object[])new Object[0]));
            if (plugin != null) {
                formattedMap.put(AuditParamsNames.MODULE_NAME.toString(), plugin.getName());
            } else {
                formattedMap.put(AuditParamsNames.MODULE_ID.toString(), pluginId);
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

