/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class ProcessReservationFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(ProcessReservationFormatter.class);
    private final String idKey = "id";
    private final String processIdKey = "processId";
    private final String calendarResourceIdKey = "calendarResourceId";
    private final String allDayKey = "allDay";
    private final String startDateTimeUtcKey = "startDateTimeUtc";
    private final String endDateTimeUtcKey = "endDateTimeUtc";
    private final String nameTemplateKey = "nameTemplate";
    private final String errorMessageKey = "ERROR_MESSAGE";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            Locale locale = LocaleContextHolder.getLocale();
            String id = map.get("id");
            String processId = map.get("processId");
            String calendarResourceId = map.get("calendarResourceId");
            String allDay = map.get("allDay");
            String startDateTimeUtc = map.get("startDateTimeUtc");
            String endDateTimeUtc = map.get("endDateTimeUtc");
            String nameTemplate = map.get("nameTemplate");
            String errorMessage = map.get("ERROR_MESSAGE");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                formattedMap.put(AuditParamsNames.PROCESS_RESERVATION_ID.name(), this.formatTextValueChange(id));
            }
            if (StringUtils.isNotBlank((CharSequence)processId)) {
                formattedMap.put(AuditParamsNames.PROCESS_RESERVATION_PROCESS_ID.name(), this.formatTextValueChange(processId));
            }
            if (StringUtils.isNotBlank((CharSequence)calendarResourceId)) {
                formattedMap.put(AuditParamsNames.PROCESS_RESERVATION_CALENDAR_RESOURCE_ID.name(), this.formatTextValueChange(calendarResourceId));
            }
            if (StringUtils.isNotBlank((CharSequence)allDay)) {
                formattedMap.put(AuditParamsNames.PROCESS_RESERVATION_ALL_DAY.name(), this.translateBooleanValue(allDay, locale));
            }
            if (StringUtils.isNotBlank((CharSequence)startDateTimeUtc)) {
                formattedMap.put(AuditParamsNames.PROCESS_RESERVATION_START_DATE_TIME_UTC.name(), this.formatTextValueChange(startDateTimeUtc));
            }
            if (StringUtils.isNotBlank((CharSequence)endDateTimeUtc)) {
                formattedMap.put(AuditParamsNames.PROCESS_RESERVATION_END_DATE_TIME_UTC.name(), this.formatTextValueChange(endDateTimeUtc));
            }
            if (StringUtils.isNotBlank((CharSequence)nameTemplate)) {
                formattedMap.put(AuditParamsNames.PROCESS_RESERVATION_NAME_TEMPLATE.name(), this.formatTextValueChange(nameTemplate));
            }
            if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                formattedMap.put(AuditParamsNames.ERROR_MESSAGE.toString(), map.get(errorMessage));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

