/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class DeleteDocClassProtectionConditionFormatter
extends Formatter {
    private final String documentClassIdKey = "documentClassId";
    private final String conditionIdKey = "conditionId";
    private final String conditionTypeKey = "conditionType";
    private final String conditionKey = "condition";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
        Long documentClassId = Long.valueOf(map.get("documentClassId"));
        Long conditionId = Long.valueOf(map.get("conditionId"));
        String conditionType = map.get("conditionType");
        String condition = map.get("condition");
        DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
        DocumentClass documentClass = (DocumentClass)documentClassService.get((Serializable)documentClassId);
        if (documentClass != null) {
            formattedMap.put(AuditParamsNames.DOC_CLASS_NAME.name(), documentClassService.getDocumentClassTranslation(documentClassId, TranslatedFieldType.NAME));
        } else {
            formattedMap.put(AuditParamsNames.DOC_CLASS_ID.name(), documentClassId.toString());
        }
        formattedMap.put(AuditParamsNames.CONDITION_RIGHT_ID.name(), conditionId.toString());
        formattedMap.put(AuditParamsNames.CONDITION_RIGHT_TYPE.name(), MessageHelper.getMessage((String)conditionType));
        formattedMap.put(AuditParamsNames.CONDITION_RIGHT_CONDITION.name(), condition);
        return formattedMap;
    }
}

