/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAndDeleteRolesFromPositionFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(AddAndDeleteRolesFromPositionFormatter.class);
    private final String positionIdKey = "positionId";
    private final String roleIdKey = "roleId";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String positionId = map.get("positionId");
            String roleId = map.get("roleId");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            StructureService positionService = ServiceFactory.getStructureService();
            RoleService roleService = ServiceFactory.getRoleService();
            Position position = positionService.getPosition(Long.valueOf(positionId), new String[0]);
            Role role = roleService.getRole(Long.valueOf(roleId));
            if (position != null) {
                formattedMap.put(AuditParamsNames.POSITION_NAME.toString(), position.getName());
            } else {
                formattedMap.put(AuditParamsNames.POSITION_ID.toString(), positionId);
            }
            if (role != null) {
                formattedMap.put(AuditParamsNames.ROLE_NAME.toString(), role.getRoleName());
            } else {
                formattedMap.put(AuditParamsNames.ROLE_ID.toString(), roleId);
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

