( function( Ext ) {
    Ext.define( 'Suncode.audit.view.ExportWindow', {
        extend: 'Ext.window.Window',
        requires: [ 'Suncode.audit.store.AuditTypesStore', 'Suncode.audit.store.UserStore' ],
        alias: 'widget.export-window',
        title: PW.t('reportGeneration'),
        modal: true,
        shadow: false,
        constrain: true,
        autoWidth: true,
        autoHeight: true,
        padding: 10,
        initComponent: function() {
            var orderByTab = [ [ 'userId', PW.t('user') ], [ 'ipAddress', PW.t('ipAddress') ],
                            [ 'threadId', PW.t('threadId') ], [ 'auditStarted', PW.t('startTime') ],
                            [ 'auditStopped', PW.t('stopTime') ], [ 'auditDuration', PW.t('duration') ],
                            [ 'auditSuccess', PW.t('status') ] ];
            var sortDirTab = [ [ 'ASC', PW.t('ascending') ], [ 'DESC', PW.t('descending') ] ];

            this.items = [ {
                xtype: 'form',
                border: false,
                frame: false,
                width: 600,
                buttonAlign: 'center',
                items: [ {
                    xtype: 'textfield',
                    name: 'exportType',
                    value: this.exportType,
                    hidden: true
                }, {
                    xtype: 'combo',
                    name: 'orderBy',
                    triggerAction: 'all',
                    fieldLabel: PW.t('sorting'),
                    labelWidth: 200,
                    anchor: '100%',
                    labelCls: 'x-audit-label',
                    mode: 'local',
                    store: new Ext.data.ArrayStore( {
                        fields: [ 'orderById', 'orderByName' ],
                        data: orderByTab
                    } ),
                    valueField: 'orderById',
                    displayField: 'orderByName',
                    forceSelection: true,
                    value: this.sortInfo.property
                }, {
                    xtype: 'combo',
                    name: 'sortDir',
                    triggerAction: 'all',
                    fieldLabel: PW.t('sortDirection'),
                    labelWidth: 200,
                    anchor: '100%',
                    labelCls: 'x-audit-label',
                    mode: 'local',
                    store: new Ext.data.ArrayStore( {
                        fields: [ 'sortById', 'sortByName' ],
                        data: sortDirTab
                    } ),
                    valueField: 'sortById',
                    displayField: 'sortByName',
                    forceSelection: true,
                    value: this.sortInfo.direction
                } ],
                buttons: [ {
                    id: 'exportWindowButton' + this.exportType,
                    cls: 'x-btn-text-icon',
                    icon: this.generateButtonIcon,
                    text: PW.t('generate'),
                    scope: this,
                    handler: function() {
                        var me = this;

                        if(this.totalCount > 1000000) {
                            Ext.MessageBox.show({
                                msg: PW.t('Do_pliku_xlsx_maksymalnie_mozna_wyeksportowac_1_mln_audytow', me.totalCount),
                                buttons: Ext.MessageBox.YESNO,
                                icon: Ext.MessageBox.QUESTION,
                                width: 400,
                                fn: function(btn) {
                                    if(btn === 'yes') {
                                        me.export();
                                    }
                                }
                            });
                        }
                        else {
                            this.export();
                        }
                    }
                } ]
            } ];

            this.callParent();
        },

        export: function() {
            this.down( 'form' ).getForm().submit( {
                standardSubmit: true,
                url: 'com.suncode.pwfl.audit.servlet.ExportAudits.customServlet',
                params: this.filterConfig,
                failure: function( form, action ) {
                    Ext.Msg.show( {
                        title: PW.t('warn'),
                        msg: PW.t('reportGenerationError'),
                        buttons: Ext.Msg.OK,
                        icon: Ext.Msg.ERROR
                    } );
                }
            } );
        }
    } );
}( this.Ext4 ) );