/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.plusmpm.i18n.I18Nxpdl;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class SaveProcessSettingsFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(SaveProcessSettingsFormatter.class);
    private final String processDefIdKey = "procTypeId";
    private final String acceptTaskWithPasswordKey = "acceptTaskWithPassword";
    private final String showDocumentsPanelKey = "showDocumentsPanel";
    private final String showInfoPanelKey = "showInfoPanel";
    private final String showDescriptionPanelKey = "showDescriptionPanel";
    private final String showHistoryPanelKey = "showHistoryPanel";
    private final String showMapPanelKey = "showMapPanel";
    private final String futureTasksKey = "futureTasks";
    private final String notifsKey = "notifs";
    private final String allowMobileKey = "allowMobile";
    private final String iconKey = "icon";
    private final String iconColorKey = "iconColor";
    private final String processAbbreviationKey = "processAbbreviation";
    private final String processDashboardKey = "processDashboard";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String processDefId = map.get("procTypeId");
            String acceptTaskWithPassword = map.get("acceptTaskWithPassword");
            String showDocumentsPanel = map.get("showDocumentsPanel");
            String showInfoPanel = map.get("showInfoPanel");
            String showDescriptionPanel = map.get("showDescriptionPanel");
            String showHistoryPanel = map.get("showHistoryPanel");
            String showMapPanel = map.get("showMapPanel");
            String futureTasks = map.get("futureTasks");
            String notifs = map.get("notifs");
            String allowMobile = map.get("allowMobile");
            String icon = map.get("icon");
            String iconColor = map.get("iconColor");
            String processAbbreviation = map.get("processAbbreviation");
            String processDashboard = map.get("processDashboard");
            Locale locale = LocaleContextHolder.getLocale();
            I18Nxpdl xpdl = new I18Nxpdl(locale);
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), this.getProcessName(processDefId, xpdl));
            formattedMap.put(AuditParamsNames.ACCEPT_TASK_WITH_PASSWORD.toString(), this.translateBooleanValue(acceptTaskWithPassword, locale));
            formattedMap.put(AuditParamsNames.SHOW_DOCUMENTS_PANEL.toString(), this.translateBooleanValue(showDocumentsPanel, locale));
            formattedMap.put(AuditParamsNames.SHOW_INFO_PANEL.toString(), this.translateBooleanValue(showInfoPanel, locale));
            formattedMap.put(AuditParamsNames.SHOW_DESCRIPTION_PANEL.toString(), this.translateBooleanValue(showDescriptionPanel, locale));
            formattedMap.put(AuditParamsNames.SHOW_HISTORY_PANEL.toString(), this.translateBooleanValue(showHistoryPanel, locale));
            formattedMap.put(AuditParamsNames.SHOW_MAP_PANEL.toString(), this.translateBooleanValue(showMapPanel, locale));
            formattedMap.put(AuditParamsNames.FUTURE_TASKS.toString(), this.translateBooleanValue(futureTasks, locale));
            formattedMap.put(AuditParamsNames.NOTIFS.toString(), this.translateBooleanValue(notifs, locale));
            formattedMap.put(AuditParamsNames.ALLOW_MOBILE.toString(), this.translateBooleanValue(allowMobile, locale));
            formattedMap.put(AuditParamsNames.PROCESS_DASHBOARD.toString(), this.translateBooleanValue(processDashboard, locale));
            if (Objects.nonNull(icon)) {
                formattedMap.put(AuditParamsNames.ICON.toString(), this.formatTextValueChange(icon));
            }
            if (Objects.nonNull(iconColor)) {
                formattedMap.put(AuditParamsNames.ICON_COLOR.toString(), this.formatTextValueChange(iconColor));
            }
            if (Objects.nonNull(processAbbreviation)) {
                formattedMap.put(AuditParamsNames.PROCESS_ABBREVIATION.toString(), this.formatTextValueChange(processAbbreviation));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

