/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class PasswordPolicyUpdateFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(PasswordPolicyUpdateFormatter.class);
    private final String profileKeyKey = "profileKey";
    private final String changePasswordTimeKey = "changePasswordTime";
    private final String minPasswordLengthKey = "minPasswordLength";
    private final String maxPasswordLengthKey = "maxPasswordLength";
    private final String requireVariableLetterSizeKey = "requireVariableLetterSize";
    private final String requireNumbersKey = "requireNumbers";
    private final String requireSpecialCharactersKey = "requireSpecialCharacters";
    private final String numberOfRememberedBackPasswordsKey = "numberOfRememberedBackPasswords";
    private final String blockAfterLoginAttemptsKey = "blockAfterLoginAttempts";
    private final String unblockAfterKey = "unblockAfter";
    private final String sendUnblockingEmailKey = "sendUnblockingEmail";
    private final String forcePassChangeKey = "forcePassChange";
    private final String allowUniversalPasswordLoginKey = "allowUniversalPasswordLogin";
    private final String checkPasswordAgainstDictionaryKey = "checkPasswordAgainstDictionary";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String profileKey = map.get("profileKey");
            String changePasswordTime = map.get("changePasswordTime");
            String minPasswordLength = map.get("minPasswordLength");
            String maxPasswordLength = map.get("maxPasswordLength");
            String requireVariableLetterSize = map.get("requireVariableLetterSize");
            String requireNumbers = map.get("requireNumbers");
            String requireSpecialCharacters = map.get("requireSpecialCharacters");
            String numberOfRememberedBackPasswords = map.get("numberOfRememberedBackPasswords");
            String blockAfterLoginAttempts = map.get("blockAfterLoginAttempts");
            String unblockAfter = map.get("unblockAfter");
            String sendUnblockingEmail = map.get("sendUnblockingEmail");
            String forcePassChange = map.get("forcePassChange");
            String allowUniversalPasswordLogin = map.get("allowUniversalPasswordLogin");
            String checkPasswordAgainstDictionary = map.get("checkPasswordAgainstDictionary");
            Locale locale = LocaleContextHolder.getLocale();
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.PROFILEKEY.toString(), profileKey);
            formattedMap.put(AuditParamsNames.CHANGEPASSWORDTIME.toString(), this.ensureTextValueNotNull(changePasswordTime));
            formattedMap.put(AuditParamsNames.MINPASSWORDLENGTH.toString(), minPasswordLength);
            formattedMap.put(AuditParamsNames.MAXPASSWORDLENGTH.toString(), maxPasswordLength);
            formattedMap.put(AuditParamsNames.REQUIREVARIABLELETTERSIZE.toString(), this.translateBooleanValue(requireVariableLetterSize, locale));
            formattedMap.put(AuditParamsNames.REQUIRENUMBERS.toString(), this.translateBooleanValue(requireNumbers, locale));
            formattedMap.put(AuditParamsNames.REQUIRESPECIALCHARACTERS.toString(), this.translateBooleanValue(requireSpecialCharacters, locale));
            formattedMap.put(AuditParamsNames.NUMBEROFREMEMBEREDBACKPASSWORDS.toString(), this.ensureTextValueNotNull(numberOfRememberedBackPasswords));
            formattedMap.put(AuditParamsNames.BLOCKAFTERLOGINATTEMPTS.toString(), this.ensureTextValueNotNull(blockAfterLoginAttempts));
            formattedMap.put(AuditParamsNames.UNBLOCKAFTER.toString(), this.ensureTextValueNotNull(unblockAfter));
            formattedMap.put(AuditParamsNames.SENDUNBLOCKINGEMAIL.toString(), this.translateBooleanValue(sendUnblockingEmail, locale));
            formattedMap.put(AuditParamsNames.FORCEPASSCHANGE.toString(), this.translateBooleanValue(forcePassChange, locale));
            formattedMap.put(AuditParamsNames.ALLOW_UNIVERSAL_PASSWORD_LOGIN.toString(), this.translateBooleanValue(allowUniversalPasswordLogin, locale));
            formattedMap.put(AuditParamsNames.CHECK_PASSWORD_AGAINST_DICTIONARY.toString(), this.translateBooleanValue(checkPasswordAgainstDictionary, locale));
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

