/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.parser.wrapper.XpdlKey;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.archive.DocumentDetachProtectionTypes;
import com.suncode.pwfl.audit.form.FormatterHandler;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.context.i18n.LocaleContextHolder;

/*
 * Exception performing whole class analysis ignored.
 */
public class Formatter
implements FormatterHandler {
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        return new LinkedHashMap<String, String>(map);
    }

    protected String ensureTextValueNotNull(String value) {
        return value == null || value.equalsIgnoreCase("null") ? "" : value;
    }

    protected String translateIndexType(String type, Locale locale) {
        if (StringUtils.isNotBlank((CharSequence)type) && type.split(";", -1).length > 1) {
            String[] types = type.split(";", -1);
            return this.translateIndexTypeName(types[0], locale) + " > " + this.translateIndexTypeName(types[1], locale);
        }
        return this.translateIndexTypeName(type, locale);
    }

    protected String translateIndexTypeName(String type, Locale locale) {
        if (StringUtils.equals((CharSequence)type, (CharSequence)"integer")) {
            return MessageHelper.getMessage((String)"Calkowity", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"float")) {
            return MessageHelper.getMessage((String)"Zmiennoprzecinkowy", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"string")) {
            return MessageHelper.getMessage((String)"Tekstowy", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"date")) {
            return MessageHelper.getMessage((String)"Data", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"list")) {
            return MessageHelper.getMessage((String)"Lista_wartosci", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"boolean")) {
            return MessageHelper.getMessage((String)"Logiczny", (Locale)locale, (Object[])new Object[0]);
        }
        return type;
    }

    protected String translateRightLevel(String rightLevel, Locale locale) {
        if (StringUtils.isNotBlank((CharSequence)rightLevel) && rightLevel.split(";", -1).length > 1) {
            String[] types = rightLevel.split(";", -1);
            return this.translateRightLevelName(types[0], locale) + " > " + this.translateRightLevelName(types[1], locale);
        }
        return this.translateRightLevelName(rightLevel, locale);
    }

    protected String translateRightLevelName(String rightLevel, Locale locale) {
        if (StringUtils.equals((CharSequence)rightLevel, (CharSequence)"read")) {
            return MessageHelper.getMessage((String)"Odczyt", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)rightLevel, (CharSequence)"modify")) {
            return MessageHelper.getMessage((String)"Modyfikacja", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)rightLevel, (CharSequence)"delete")) {
            return MessageHelper.getMessage((String)"Usuwanie", (Locale)locale, (Object[])new Object[0]);
        }
        return MessageHelper.getMessage((String)"Brak", (Locale)locale, (Object[])new Object[0]);
    }

    protected String translateDocumentDetachProtectionType(String documentDetach, Locale locale) {
        if (StringUtils.isNotBlank((CharSequence)documentDetach) && documentDetach.split(";", -1).length > 1) {
            String[] types = documentDetach.split(";", -1);
            return this.translateDocumentDetachProtectionTypeName(types[0], locale) + " > " + this.translateDocumentDetachProtectionTypeName(types[1], locale);
        }
        return this.translateDocumentDetachProtectionTypeName(documentDetach, locale);
    }

    protected String translateDocumentDetachProtectionTypeName(String documentDetach, Locale locale) {
        if (DocumentDetachProtectionTypes.ONLY_ADDED_HERE.getType().equals(documentDetach)) {
            return MessageHelper.getMessage((String)"Added_here", (Locale)locale, (Object[])new Object[0]);
        }
        if (DocumentDetachProtectionTypes.ALWAYS.getType().equals(documentDetach)) {
            return MessageHelper.getMessage((String)"Always", (Locale)locale, (Object[])new Object[0]);
        }
        return MessageHelper.getMessage((String)"Default", (Locale)locale, (Object[])new Object[0]);
    }

    protected String translateBooleanValue(String value, Locale locale) {
        if (value != null && value.split(";", -1).length > 1) {
            String[] changedValues = value.split(";", -1);
            String oldValue = this.getBooleanValue(changedValues[0]);
            String newValue = this.getBooleanValue(changedValues[1]);
            return MessageHelper.getMessage((String)"AUDIT_PARAM_VALUE_".concat(oldValue.toUpperCase()), (Locale)locale, (Object[])new Object[0]) + " > " + MessageHelper.getMessage((String)"AUDIT_PARAM_VALUE_".concat(newValue.toUpperCase()), (Locale)locale, (Object[])new Object[0]);
        }
        return MessageHelper.getMessage((String)"AUDIT_PARAM_VALUE_".concat(this.getBooleanValue(value).toUpperCase()), (Locale)locale, (Object[])new Object[0]);
    }

    protected String getBooleanValue(String value) {
        if (StringUtils.isBlank((CharSequence)value) || "null".equalsIgnoreCase(value) || "off".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            return "FALSE";
        }
        return "TRUE";
    }

    protected String getCustomName(String value) {
        if (StringUtils.isNotBlank((CharSequence)value) && value.split(";", -1).length > 1) {
            String[] values = value.split(";", -1);
            return values[0] + " > " + values[1];
        }
        return value;
    }

    protected String getTranslatedCustomName(String value) {
        if (StringUtils.isNotBlank((CharSequence)value) && value.split(";", -1).length > 1) {
            String[] values = value.split(";", -1);
            String translatedValue1 = StringUtils.isNotBlank((CharSequence)values[0]) ? MessageHelper.getMessage((String)values[0]) : "";
            String translatedValue2 = StringUtils.isNotBlank((CharSequence)values[1]) ? MessageHelper.getMessage((String)values[1]) : "";
            return translatedValue1 + " > " + translatedValue2;
        }
        return StringUtils.isNotBlank((CharSequence)value) ? MessageHelper.getMessage((String)value) : "";
    }

    static String buildSymbolAndNameChange(String value) {
        if (StringUtils.isNotBlank((CharSequence)value) && value.split(";", -1).length > 1) {
            String[] values = value.split(";", -1);
            return Formatter.buildSymbolAndName((String)values[0]) + " > " + Formatter.buildSymbolAndName((String)values[1]);
        }
        return Formatter.buildSymbolAndName((String)value);
    }

    static String buildSymbolAndName(String value) {
        String[] values;
        if (StringUtils.isNotBlank((CharSequence)value) && (values = value.split(" - ", -1)).length > 1) {
            return values[0] + " - " + values[1];
        }
        return value;
    }

    protected String getProcessName(String processDefId, I18Nxpdl xpdl) {
        Package pack = XpdlPackageManager.getInstance().getPackageByProcessDefinitionId(processDefId);
        if (pack != null) {
            String processName;
            WorkflowProcess wp = pack.getWorkflowProcess(processDefId);
            String key = XpdlKey.forPackage((String)pack.getId()).forProcess(processDefId).getKey();
            if (key.equals(processName = xpdl.getString(key))) {
                return wp.getName();
            }
            return processName;
        }
        return processDefId;
    }

    protected String getActivityName(String processDefId, String activityDefId, I18Nxpdl xpdl) {
        Package pack = XpdlPackageManager.getInstance().getPackageByProcessDefinitionId(processDefId);
        if (pack != null) {
            String activityName;
            String key = XpdlKey.forPackage((String)pack.getId()).forProcess(processDefId).forActivity(activityDefId).getKey();
            if (key.equals(activityName = xpdl.getString(key))) {
                WorkflowProcess wp = pack.getWorkflowProcess(processDefId);
                ArrayList activities = wp.getActivities().toElements();
                Optional<Activity> activity = activities.stream().filter(wpActivity -> wpActivity.getId().equals(activityDefId)).findFirst();
                return activity.isPresent() ? activity.get().getName() : activityDefId;
            }
            return activityName;
        }
        return activityDefId;
    }

    protected String formatTextValueChange(String changeString) {
        return this.formatTextValueChange(changeString, ";");
    }

    protected String formatTextValueChange(String changeString, String separator) {
        return this.formatTextValueChange(changeString, null, separator);
    }

    protected String formatTextValueChange(String changeString, Function<String, String> translationFunction) {
        return this.formatTextValueChange(changeString, translationFunction, ";");
    }

    protected String formatTextValueChange(String changeString, Function<String, String> translationFunction, String separator) {
        if (StringUtils.isBlank((CharSequence)changeString)) {
            return changeString;
        }
        String[] separatedValues = changeString.split(separator, -1);
        if (separatedValues.length < 2) {
            return translationFunction != null ? translationFunction.apply(changeString) : changeString;
        }
        String translatedOldValue = translationFunction != null ? translationFunction.apply(separatedValues[0]) : separatedValues[0];
        String translatedNewValue = translationFunction != null ? translationFunction.apply(separatedValues[1]) : separatedValues[1];
        return String.format("%s > %s", translatedOldValue, translatedNewValue);
    }

    protected String translateReplacementVariableName(String processDefId, String variableId) {
        XpdlPackageManager xpdlPackageManager = XpdlPackageManager.getInstance();
        I18Nxpdl xpdlTranslator = new I18Nxpdl(LocaleContextHolder.getLocale());
        Package pack = xpdlPackageManager.getPackageByProcessDefinitionId(processDefId);
        if (pack == null) {
            return variableId;
        }
        String translatedName = xpdlTranslator.getString(XpdlKey.forPackage((String)pack.getId()).forProcess(processDefId).forDataField(variableId).getKey());
        return translatedName.isEmpty() ? variableId : translatedName;
    }

    protected String translatePlanMode(String planMode) {
        return MessageHelper.getMessage((String)("AUDIT_PARAM_SCHEDULED_TASK_PLAN_MODE_" + planMode));
    }

    protected String translateUserInfoType(String value) {
        return MessageHelper.getMessage((String)("changeuser.replacement.type." + value.toLowerCase()));
    }
}

