/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.plusmpm.i18n.I18NCustom;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.favourites.FavouritesRegistry;
import com.suncode.pwfl.favourites.view.Definition;
import com.suncode.pwfl.util.SpringContext;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class FavouriteElementFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(FavouriteElementFormatter.class);
    private final String favouriteSetIdKey = "FAVOURITE_SET_ID";
    private final String favouriteElementIdKey = "FAVOURITE_ELEMENT_ID";
    private final String favouriteElementNameKey = "FAVOURITE_ELEMENT_NAME";
    private final String favouriteElementTypeKey = "FAVOURITE_ELEMENT_TYPE";
    private final String favouriteElementParameterKey = "FAVOURITE_ELEMENT_PARAMETER";
    private final String favouriteElementCountedKey = "FAVOURITE_ELEMENT_COUNTED";
    private FavouritesRegistry favouritesRegistry = (FavouritesRegistry)SpringContext.getBean(FavouritesRegistry.class);

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.FAVOURITE_SET_ID.name(), map.get("FAVOURITE_SET_ID"));
            String elementId = map.get("FAVOURITE_ELEMENT_ID");
            if (StringUtils.isNotBlank((String)elementId)) {
                formattedMap.put(AuditParamsNames.FAVOURITE_ELEMENT_ID.name(), elementId);
            }
            formattedMap.put(AuditParamsNames.FAVOURITE_ELEMENT_NAME.name(), this.getTranslatedName(map.get("FAVOURITE_ELEMENT_NAME")));
            String type = map.get("FAVOURITE_ELEMENT_TYPE");
            String parameter = map.get("FAVOURITE_ELEMENT_PARAMETER");
            Definition definition = this.favouritesRegistry.getDefinition(type, parameter);
            if (definition == null) {
                formattedMap.put(AuditParamsNames.FAVOURITE_ELEMENT_TYPE.name(), type);
            } else {
                formattedMap.put(AuditParamsNames.FAVOURITE_ELEMENT_TYPE.name(), definition.getTypeDescription());
            }
            if (StringUtils.isNotBlank((String)parameter)) {
                formattedMap.put(AuditParamsNames.FAVOURITE_ELEMENT_PARAMETER.name(), parameter);
            }
            formattedMap.put(AuditParamsNames.FAVOURITE_ELEMENT_COUNTED.name(), this.translateBooleanValue(map.get("FAVOURITE_ELEMENT_COUNTED"), LocaleContextHolder.getLocale()));
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String getTranslatedName(String name) {
        I18NCustom custom = new I18NCustom(LocaleContextHolder.getLocale());
        return custom.getStringSilent(name);
    }
}

