/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.plusmpm.database.scheduledTasks.ScheduledTasksTable;
import com.plusmpm.database.scheduledTasks.dao.ScheduledTasksTableDAO;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class ManageScheduledTaskFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(ManageScheduledTaskFormatter.class);
    private final String idKey = "id";
    private final String propertyKey = "property";
    private final String valueKey = "value";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String id = map.get("id");
            String property = map.get("property");
            String value = map.get("value");
            ScheduledTasksTable scheduledTask = ScheduledTasksTableDAO.get((Long)Long.valueOf(id));
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (scheduledTask != null) {
                formattedMap.put(AuditParamsNames.SCHEDULED_TASK_NAME.toString(), scheduledTask.getName());
            } else {
                formattedMap.put(AuditParamsNames.SCHEDULED_TASK_ID.toString(), id);
            }
            if (StringUtils.isNotBlank((CharSequence)property)) {
                formattedMap.put(AuditParamsNames.SCHEDULED_TASK_PROPERTY.toString(), this.translateProperty(property));
                formattedMap.put(AuditParamsNames.SCHEDULED_TASK_PROPERTY_VALUE.toString(), this.formatValue(property, value));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String translateProperty(String property) {
        Locale locale = LocaleContextHolder.getLocale();
        if (StringUtils.equals((CharSequence)property, (CharSequence)"name")) {
            return MessageHelper.getOptionalMessage((String)"Nazwa_zadania_zaplanowanego", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)"desc")) {
            return MessageHelper.getOptionalMessage((String)"Opis_zadania_zaplanowanego", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)"nextRun")) {
            return MessageHelper.getOptionalMessage((String)"Data_nastepnego_uruchomienia", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)"active")) {
            return MessageHelper.getOptionalMessage((String)"Aktywne", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)"saveHistory")) {
            return MessageHelper.getOptionalMessage((String)"Zapisuj_historie_wykonywania", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)"period")) {
            return MessageHelper.getOptionalMessage((String)"Okres_powtorzen", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.startsWith((CharSequence)property, (CharSequence)"param")) {
            Integer position = new Integer(property.substring(5));
            return MessageHelper.getOptionalMessage((String)"Parametr", (Locale)locale, (Object[])new Object[0]) + " " + position;
        }
        return property;
    }

    private String formatValue(String property, String value) {
        if (StringUtils.equals((CharSequence)property, (CharSequence)"nextRun")) {
            return value.replace("T", " ");
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)"saveHistory")) {
            Locale locale = LocaleContextHolder.getLocale();
            if (StringUtils.isBlank((CharSequence)value)) {
                value = "FALSE";
            }
            return MessageHelper.getOptionalMessage((String)"AUDIT_PARAM_VALUE_".concat(value.toUpperCase()), (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)"period")) {
            return value + " ms";
        }
        return value;
    }
}

