/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddDocumentClassAssociationFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(AddDocumentClassAssociationFormatter.class);
    private static final String baseClassKey = "baseClass";
    private static final String associatedClassKey = "associatedClass";
    private static final String associatedIndexesKey = "associatedIndexes";
    private static final String displayedIndexesKey = "displayedIndexes";
    private static final String separatorKey = "separator";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String baseClass = map.get(baseClassKey);
            String associatedClass = map.get(associatedClassKey);
            String associatedIndexes = map.get(associatedIndexesKey);
            String displayedIndexes = map.get(displayedIndexesKey);
            String separator = map.get(separatorKey);
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.BASE_CLASS.toString(), baseClass);
            formattedMap.put(AuditParamsNames.ASSOCIATED_CLASS.toString(), associatedClass);
            formattedMap.put(AuditParamsNames.ASSOCIATED_INDEXES.toString(), this.getAssociatedIndexes(associatedIndexes));
            formattedMap.put(AuditParamsNames.DISPLAYED_INDEXES.toString(), displayedIndexes);
            formattedMap.put(AuditParamsNames.SEPARATOR.toString(), separator);
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String getAssociatedIndexes(String indexes) {
        return Arrays.stream(indexes.split(";")).map(this::getIndexesPair).collect(Collectors.joining("; "));
    }

    private String getIndexesPair(String joinedIndexes) {
        String[] indexes = joinedIndexes.split(",");
        return indexes[0] + " -> " + indexes[1];
    }
}

