/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.calendar.user.api.UserCalendarService;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.SpringContext;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCalendarFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(UserCalendarFormatter.class);
    private final String idKey = "id";
    private final String nameKey = "name";
    private final String colorKey = "color";
    private final String resourceGroupsIdsKey = "resourceGroupsIds";
    private final String newCalendarIdKey = "newCalendarId";
    private final String calendarNameKey = "calendarName";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String id = map.get("id");
            String name = map.get("name");
            String color = map.get("color");
            String resourceGroupsIds = map.get("resourceGroupsIds");
            String newCalendarId = map.get("newCalendarId");
            String calendarName = map.get("calendarName");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                formattedMap.put(AuditParamsNames.CALENDAR_ID.name(), this.formatTextValueChange(id));
            }
            if (StringUtils.isNotBlank((CharSequence)name)) {
                formattedMap.put(AuditParamsNames.CALENDAR_NAME.name(), this.formatTextValueChange(name));
            }
            if (StringUtils.isNotBlank((CharSequence)color)) {
                formattedMap.put(AuditParamsNames.CALENDAR_COLOR.name(), this.formatTextValueChange(color));
            }
            if (StringUtils.isNotBlank((CharSequence)resourceGroupsIds)) {
                formattedMap.put(AuditParamsNames.CALENDAR_RESOURCE_GROUPS.name(), this.formatTextValueChange(resourceGroupsIds));
            }
            if (StringUtils.isNotBlank((CharSequence)newCalendarId)) {
                formattedMap.put(AuditParamsNames.NEW_CALENDAR_ID.name(), this.formatTextValueChange(newCalendarId));
            }
            if (StringUtils.isNotBlank((CharSequence)calendarName)) {
                formattedMap.put(AuditParamsNames.CALENDAR_NAME.name(), this.getTranslatedCalendarName(id, calendarName));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String getTranslatedCalendarName(String id, String fallbackName) {
        try {
            UserCalendarService userCalendarService = (UserCalendarService)SpringContext.getBean(UserCalendarService.class);
            String calendarName = userCalendarService.getCalendarTranslation(Long.valueOf(id), TranslatedFieldType.NAME);
            return StringUtils.isNotBlank((CharSequence)calendarName) ? calendarName : fallbackName;
        }
        catch (Exception ignored) {
            return fallbackName;
        }
    }
}

