/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.object.ProcessDef;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.audit.util.AuditTools;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DeleteProcessProtectionFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(DeleteProcessProtectionFormatter.class);
    private final String userIdKey = "userId";
    private final String isGroupKey = "isGroup";
    private final String processDefIdKey = "procTypeId";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String userId = map.get("userId");
            String isGroup = map.get("isGroup");
            String processDefId = map.get("procTypeId");
            if (StringUtils.isBlank((String)isGroup)) {
                isGroup = "FALSE";
            }
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), this.getProcessName(processDefId));
            if (Boolean.parseBoolean(isGroup)) {
                formattedMap.put(AuditParamsNames.USER_NAME.toString(), userId);
            } else {
                formattedMap.put(AuditParamsNames.USER_NAME.toString(), AuditTools.getUserRealName((String)userId));
            }
            formattedMap.put(AuditParamsNames.IS_GROUP.toString(), MessageHelper.getOptionalMessage((String)"AUDIT_PARAM_VALUE_".concat(isGroup.toUpperCase())));
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String getProcessName(String processDefId) {
        ProcessDef processDef = new ProcessDef(processDefId);
        return processDef.getProcessName();
    }
}

