(function (Ext) {
    Ext.define('Suncode.audit.store.UserStore', {
        extend: 'Ext.data.Store',
        requires: ['Suncode.audit.model.UserModel'],
        alias: 'widget.audit-types-store',
        model: 'Suncode.audit.model.UserModel',
        autoLoad: true,
        pageSize: 10,
        folderSort: true,
        proxy: {
            type: 'ajax',
            url: 'api/users/query',
            actionMethods: {
                read: 'GET'
            },
            reader: {
                type: 'json',
                root: 'data'
            }
        }, sorters: [{
            property: 'userName',
            direction: 'ASC'
        }]
    });
}(this.Ext4));