/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class AddLinkConnectionFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(AddLinkConnectionFormatter.class);
    private final String linkIdKey = "linkId";
    private final String documentClassIdKey = "docClassId";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String linkId = map.get("linkId");
            String documentClassId = map.get("docClassId");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            Link link = ((LinkService)SpringContext.getBean(LinkService.class)).getLink(Long.valueOf(linkId), new String[0]);
            if (link != null) {
                formattedMap.put(AuditParamsNames.LINK_NAME.toString(), link.getName());
            } else {
                formattedMap.put(AuditParamsNames.LINK_ID.toString(), linkId);
            }
            DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
            DocumentClass documentClass = (DocumentClass)documentClassService.get((Serializable)Long.valueOf(documentClassId));
            if (documentClass != null) {
                formattedMap.put(AuditParamsNames.DOC_CLASS_NAME.toString(), documentClass.getName());
            } else {
                formattedMap.put(AuditParamsNames.DOC_CLASS_ID.toString(), documentClassId);
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

