/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.servlet;

import com.suncode.pwfl.audit.Audit;
import com.suncode.pwfl.audit.object.AuditFetchResult;
import com.suncode.pwfl.audit.object.ExportConfig;
import com.suncode.pwfl.audit.object.FilterConfig;
import com.suncode.pwfl.audit.service.AuditService;
import com.suncode.pwfl.audit.util.AuditExportTypes;
import com.suncode.pwfl.audit.util.AuditExtractor;
import com.suncode.pwfl.audit.util.AuditServiceFactory;
import com.suncode.pwfl.audit.util.AuditTools;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.audit.util.ExcelAuditExtractor;
import com.suncode.pwfl.audit.util.PdfAuditExtractor;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.search.SortDirection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.MessageSourceAccessor;

public class ExportAudits
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ExportAudits.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace("************************* ExportAudits Servlet ****************************");
        ServletOutputStream outputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        String fileName = "FileName.pdf";
        String contentType = "";
        boolean isAscending = false;
        AuditExtractor extractor = null;
        MessageSourceAccessor messageSource = MessageHelper.getInstance().getMessageSourceAccessor();
        try {
            String exportType = request.getParameter("exportType");
            String orderBy = request.getParameter("orderBy");
            String sortDirection = request.getParameter("sortDir");
            AuditExportTypes type = AuditExportTypes.valueOf(exportType.toUpperCase());
            byteArrayOutputStream = new ByteArrayOutputStream();
            if (sortDirection.equalsIgnoreCase(SortDirection.ASC.toString())) {
                isAscending = true;
            }
            FilterConfig filterConfig = AuditTools.buildFilterConfig(request);
            AuditService auditService = AuditServiceFactory.getAuditService();
            Integer limit = null;
            if (type == AuditExportTypes.XLS) {
                limit = 1000000;
            }
            AuditFetchResult auditFetchResult = auditService.getAudits(orderBy, isAscending, 0, limit, filterConfig);
            ExportConfig config = new ExportConfig();
            List<Audit> audits = auditFetchResult.getAudits();
            for (Audit audit : audits) {
                audit.setAuditType(AuditTypes.getTranslatedAuditType((String)audit.getAuditType()));
            }
            config.setAudits(audits);
            config.setCount(auditFetchResult.getCount());
            config.setOutputStream(byteArrayOutputStream);
            switch (type) {
                case PDF: {
                    extractor = new PdfAuditExtractor(config);
                    contentType = "application/pdf";
                    break;
                }
                case XLS: {
                    extractor = new ExcelAuditExtractor(config);
                    contentType = "application/vnd.ms-excel";
                    break;
                }
            }
            extractor.extract();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
            fileName = messageSource.getMessage("Elementy_audytowe_systemu_Plus_Workflow");
            fileName = fileName.concat(" - ");
            fileName = fileName.concat(sdf.format(new Date(System.currentTimeMillis())));
            fileName = fileName.concat(".");
            fileName = fileName.concat(exportType.toLowerCase());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (extractor != null) {
                    extractor.close();
                }
                response.setContentType(contentType);
                response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                outputStream = response.getOutputStream();
                outputStream.write(byteArrayOutputStream.toByteArray());
                outputStream.flush();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

