/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.object.ActivityDef;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class OpenActivityFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(OpenActivityFormatter.class);
    private final String processIdKey = "processKey";
    private final String activityIdKey = "activityId";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        ActivityDef activityDef = null;
        try {
            String processId = map.get("processKey");
            String activityId = map.get("activityId");
            activityDef = new ActivityDef(processId, activityId);
            String userAgent = map.get("useragent");
            String browser = map.get("browser");
            String browserVersion = map.get("browserVersion");
            String operatingSystem = map.get("operatingSystem");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), activityDef.getProcessName());
            formattedMap.put(AuditParamsNames.ACTIVITY_NAME.toString(), activityDef.getActivityName());
            formattedMap.put(AuditParamsNames.OPERATINGSYSTEM.toString(), operatingSystem);
            formattedMap.put(AuditParamsNames.BROWSER.toString(), browser);
            formattedMap.put(AuditParamsNames.BROWSERVERSION.toString(), browserVersion);
            formattedMap.put(AuditParamsNames.USERAGENT.toString(), userAgent);
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

