/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class AddScheduledTaskFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(AddScheduledTaskFormatter.class);
    private final String classnameKey = "classname";
    private final String methodKey = "method";
    private final String nameKey = "name";
    private final String descriptionKey = "description";
    private final String categoryKey = "categoryName";
    private final String firstRunKey = "firstRun";
    private final String periodValueKey = "periodValue";
    private final String periodUnitKey = "periodUnit";
    private final String activeKey = "active";
    private final String saveHistoryKey = "savehistory";
    private final String runOnceKey = "runOnce";
    private final String startingHourKey = "startingHour";
    private final String endingHourKey = "endingHour";
    private final String maxWorkingMinutesKey = "maxWorkingMinutes";
    private final String userIdNotificationsKey = "userIdNotifications";
    private final String userNameNotificationsKey = "userNameNotifications";
    private final String emailNotificationsKey = "emailNotifications";
    private final String parametersKey = "parameters";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            Locale locale = LocaleContextHolder.getLocale();
            String periodValue = map.get("periodValue");
            String periodUnit = map.get("periodUnit");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.CLASSNAME.toString(), map.get("classname"));
            formattedMap.put(AuditParamsNames.METHOD.toString(), map.get("method"));
            formattedMap.put(AuditParamsNames.SCHEDULED_TASK_NAME.toString(), map.get("name"));
            formattedMap.put(AuditParamsNames.SCHEDULED_TASK_DESCR.toString(), map.get("description"));
            formattedMap.put(AuditParamsNames.CATEGORY.toString(), map.get("categoryName"));
            formattedMap.put(AuditParamsNames.FIRST_RUN.toString(), map.get("firstRun"));
            formattedMap.put(AuditParamsNames.PERIOD.toString(), this.buildPeriod(periodValue, periodUnit));
            formattedMap.put(AuditParamsNames.ACTIVE.toString(), this.translateBooleanValue(map.get("active"), locale));
            formattedMap.put(AuditParamsNames.SCHEDULED_TASK_SAVE_HISTORY.toString(), this.translateBooleanValue(map.get("savehistory"), locale));
            if (map.containsKey("runOnce")) {
                formattedMap.put(AuditParamsNames.SCHEDULED_TASK_RUN_ONCE.toString(), this.translateBooleanValue(map.get("runOnce"), locale));
            }
            if (map.containsKey("startingHour")) {
                formattedMap.put(AuditParamsNames.SCHEDULED_TASK_STARTING_HOUR.toString(), map.get("startingHour"));
                formattedMap.put(AuditParamsNames.SCHEDULED_TASK_ENDING_HOUR.toString(), map.get("endingHour"));
                formattedMap.put(AuditParamsNames.SCHEDULED_TASK_MAX_WORKING_MINUTES.toString(), map.get("maxWorkingMinutes"));
                if (map.containsKey("userIdNotifications")) {
                    formattedMap.put(AuditParamsNames.SCHEDULED_TASK_USER_ID_NOTIFICATIONS.toString(), map.get("userIdNotifications"));
                } else {
                    formattedMap.put(AuditParamsNames.SCHEDULED_TASK_USER_NAME_NOTIFICATIONS.toString(), map.get("userNameNotifications"));
                }
                formattedMap.put(AuditParamsNames.SCHEDULED_TASK_EMAIL_NOTIFICATIONS.toString(), map.get("emailNotifications"));
            }
            if (map.containsKey("parameters")) {
                formattedMap.put(AuditParamsNames.SCHEDULED_TASK_PARAMETERS.toString(), map.get("parameters"));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String buildPeriod(String periodValue, String periodUnit) {
        String translatedPeriodUnit = "";
        Locale locale = LocaleContextHolder.getLocale();
        if (StringUtils.equals((CharSequence)periodUnit, (CharSequence)"minute")) {
            translatedPeriodUnit = MessageHelper.getOptionalMessage((String)"minuty", (Locale)locale, (Object[])new Object[0]);
        } else if (StringUtils.equals((CharSequence)periodUnit, (CharSequence)"hour")) {
            translatedPeriodUnit = MessageHelper.getOptionalMessage((String)"godziny", (Locale)locale, (Object[])new Object[0]);
        } else if (StringUtils.equals((CharSequence)periodUnit, (CharSequence)"day")) {
            translatedPeriodUnit = MessageHelper.getOptionalMessage((String)"dni", (Locale)locale, (Object[])new Object[0]);
        } else if (StringUtils.equals((CharSequence)periodUnit, (CharSequence)"month")) {
            translatedPeriodUnit = MessageHelper.getOptionalMessage((String)"Miesiace_30_dni", (Locale)locale, (Object[])new Object[0]);
        } else if (StringUtils.equals((CharSequence)periodUnit, (CharSequence)"year")) {
            translatedPeriodUnit = MessageHelper.getOptionalMessage((String)"lata", (Locale)locale, (Object[])new Object[0]);
        } else {
            return MessageHelper.getOptionalMessage((String)"Brak", (Locale)locale, (Object[])new Object[0]);
        }
        return periodValue + " " + translatedPeriodUnit;
    }
}

