/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchDocClassFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(SearchDocClassFormatter.class);
    private final String documentClassIdKey = "lines[0].varValue";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
        try {
            String documentClassId = map.get("lines[0].varValue");
            DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
            DocumentClass documentClass = (DocumentClass)documentClassService.get((Serializable)Long.valueOf(documentClassId));
            if (documentClass != null) {
                formattedMap.put(AuditParamsNames.DOC_CLASS_NAME.name(), documentClass.getName());
            } else {
                formattedMap.put(AuditParamsNames.DOC_CLASS_ID.name(), documentClassId);
            }
            map.remove("lines[0].varValue");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (StringUtils.isBlank((CharSequence)entry.getValue()) || "null".equals(entry.getValue())) continue;
                formattedMap.put(entry.getKey(), entry.getValue());
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

