/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.calendar.process.ProcessCreateType;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class ProcessCalendarFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(ProcessCalendarFormatter.class);
    private final String idKey = "id";
    private final String nameKey = "name";
    private final String colorKey = "color";
    private final String processDefIdKey = "processDefId";
    private final String variableIdStartDateTimeKey = "variableIdStartDateTime";
    private final String variableIdEndDateTimeKey = "variableIdEndDateTime";
    private final String durationMinutesKey = "durationMinutes";
    private final String allDayKey = "allDay";
    private final String nameTemplateKey = "nameTemplate";
    private final String nameTemplateMonthKey = "nameTemplateMonth";
    private final String nameTemplateWeekKey = "nameTemplateWeek";
    private final String nameTemplateDayKey = "nameTemplateDay";
    private final String descriptionTemplateKey = "descriptionTemplate";
    private final String allowWorkdaysKey = "allowWorkdays";
    private final String allowSaturdaysKey = "allowSaturdays";
    private final String allowHolidaysKey = "allowHolidays";
    private final String processCreateTypeKey = "processCreateType";
    private final String criteriaKey = "criteria";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String id = map.get("id");
            String name = map.get("name");
            String color = map.get("color");
            String processDefId = map.get("processDefId");
            String variableIdStartDateTime = map.get("variableIdStartDateTime");
            String variableIdEndDateTime = map.get("variableIdEndDateTime");
            String durationMinutes = map.get("durationMinutes");
            String allDay = map.get("allDay");
            String nameTemplate = map.get("nameTemplate");
            String nameTemplateMonth = map.get("nameTemplateMonth");
            String nameTemplateWeek = map.get("nameTemplateWeek");
            String nameTemplateDay = map.get("nameTemplateDay");
            String descriptionTemplate = map.get("descriptionTemplate");
            String allowWorkdays = map.get("allowWorkdays");
            String allowSaturdays = map.get("allowSaturdays");
            String allowHolidays = map.get("allowHolidays");
            String processCreateType = map.get("processCreateType");
            String criteria = map.get("criteria");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                formattedMap.put(AuditParamsNames.CALENDAR_ID.name(), this.formatTextValueChange(id));
            }
            if (StringUtils.isNotBlank((CharSequence)name)) {
                formattedMap.put(AuditParamsNames.CALENDAR_NAME.name(), this.formatTextValueChange(name));
            }
            if (StringUtils.isNotBlank((CharSequence)color)) {
                formattedMap.put(AuditParamsNames.CALENDAR_COLOR.name(), this.formatTextValueChange(color));
            }
            if (StringUtils.isNotBlank((CharSequence)processDefId)) {
                formattedMap.put(AuditParamsNames.CALENDAR_VIEW_ID.name(), this.formatTextValueChange(processDefId));
            }
            if (StringUtils.isNotBlank((CharSequence)variableIdStartDateTime)) {
                formattedMap.put(AuditParamsNames.CALENDAR_VARIABLE_ID_START_DATE_TIME.name(), this.formatTextValueChange(variableIdStartDateTime));
            }
            if (StringUtils.isNotBlank((CharSequence)variableIdEndDateTime)) {
                formattedMap.put(AuditParamsNames.CALENDAR_VARIABLE_ID_END_DATE_TIME.name(), this.formatTextValueChange(variableIdEndDateTime));
            }
            if (StringUtils.isNotBlank((CharSequence)durationMinutes)) {
                formattedMap.put(AuditParamsNames.CALENDAR_DURATION_MINUTES.name(), this.formatTextValueChange(durationMinutes));
            }
            if (StringUtils.isNotBlank((CharSequence)allDay)) {
                formattedMap.put(AuditParamsNames.CALENDAR_ALL_DAY.name(), this.translateBooleanValue(allDay, LocaleContextHolder.getLocale()));
            }
            if (StringUtils.isNotBlank((CharSequence)nameTemplate)) {
                formattedMap.put(AuditParamsNames.CALENDAR_NAME_TEMPLATE.name(), this.formatTextValueChange(nameTemplate));
            }
            if (StringUtils.isNotBlank((CharSequence)nameTemplateMonth)) {
                formattedMap.put(AuditParamsNames.CALENDAR_NAME_TEMPLATE_MONTH.name(), this.formatTextValueChange(nameTemplateMonth));
            }
            if (StringUtils.isNotBlank((CharSequence)nameTemplateWeek)) {
                formattedMap.put(AuditParamsNames.CALENDAR_NAME_TEMPLATE_WEEK.name(), this.formatTextValueChange(nameTemplateWeek));
            }
            if (StringUtils.isNotBlank((CharSequence)nameTemplateDay)) {
                formattedMap.put(AuditParamsNames.CALENDAR_NAME_TEMPLATE_DAY.name(), this.formatTextValueChange(nameTemplateDay));
            }
            if (StringUtils.isNotBlank((CharSequence)descriptionTemplate)) {
                formattedMap.put(AuditParamsNames.CALENDAR_DESCRIPTION_TEMPLATE.name(), this.formatTextValueChange(descriptionTemplate));
            }
            if (StringUtils.isNotBlank((CharSequence)allowWorkdays)) {
                formattedMap.put(AuditParamsNames.CALENDAR_ALLOW_WORKDAYS.name(), this.translateBooleanValue(allowWorkdays, LocaleContextHolder.getLocale()));
            }
            if (StringUtils.isNotBlank((CharSequence)allowSaturdays)) {
                formattedMap.put(AuditParamsNames.CALENDAR_ALLOW_SATURDAYS.name(), this.translateBooleanValue(allowSaturdays, LocaleContextHolder.getLocale()));
            }
            if (StringUtils.isNotBlank((CharSequence)allowHolidays)) {
                formattedMap.put(AuditParamsNames.CALENDAR_ALLOW_HOLIDAYS.name(), this.translateBooleanValue(allowHolidays, LocaleContextHolder.getLocale()));
            }
            if (StringUtils.isNotBlank((CharSequence)processCreateType)) {
                formattedMap.put(AuditParamsNames.CALENDAR_PROCESS_CREATE_TYPE.name(), this.formatTextValueChange(processCreateType, this::getProcessCreateTypeTranslation));
            }
            if (StringUtils.isNotBlank((CharSequence)criteria)) {
                formattedMap.put(AuditParamsNames.CALENDAR_CRITERIA.name(), this.formatTextValueChange(criteria));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String getProcessCreateTypeTranslation(String processCreateType) {
        try {
            ProcessCreateType option = ProcessCreateType.valueOf((String)processCreateType);
            String translationKey = this.getProcessCreateTypeTranslationKey(option);
            return MessageHelper.getMessage((String)translationKey);
        }
        catch (Exception e) {
            return processCreateType;
        }
    }

    private String getProcessCreateTypeTranslationKey(ProcessCreateType option) {
        return switch (option) {
            default -> throw new IncompatibleClassChangeError();
            case ProcessCreateType.DISABLED -> "Nie_pozwalaj";
            case ProcessCreateType.FORM -> "Formularz";
            case ProcessCreateType.CALENDAR -> "W_kalendarzu";
        };
    }
}

