/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.calendar.resource.CalendarResourceOverlappingEventsOptions;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarResourceFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(CalendarResourceFormatter.class);
    private final String idKey = "id";
    private final String nameKey = "name";
    private final String descriptionKey = "description";
    private final String resourceGroupIdKey = "resourceGroupId";
    private final String allowOverlappingEventsKey = "allowOverlappingEvents";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String id = map.get("id");
            String name = map.get("name");
            String description = map.get("description");
            String resourceGroupId = map.get("resourceGroupId");
            String allowOverlappingEvents = map.get("allowOverlappingEvents");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                formattedMap.put(AuditParamsNames.CALENDAR_RESOURCE_ID.name(), this.formatTextValueChange(id));
            }
            if (StringUtils.isNotBlank((CharSequence)name)) {
                formattedMap.put(AuditParamsNames.CALENDAR_RESOURCE_NAME.name(), this.formatTextValueChange(name));
            }
            if (StringUtils.isNotBlank((CharSequence)description)) {
                formattedMap.put(AuditParamsNames.CALENDAR_RESOURCE_DESCRIPTION.name(), this.formatTextValueChange(description));
            }
            if (StringUtils.isNotBlank((CharSequence)resourceGroupId)) {
                formattedMap.put(AuditParamsNames.CALENDAR_RESOURCE_GROUP_ID.name(), this.formatTextValueChange(resourceGroupId));
            }
            if (StringUtils.isNotBlank((CharSequence)allowOverlappingEvents)) {
                formattedMap.put(AuditParamsNames.CALENDAR_RESOURCE_ALLOW_OVERLAPPING_EVENTS.name(), this.formatTextValueChange(allowOverlappingEvents, this::getAllowOverlappingEventsTranslation));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String getAllowOverlappingEventsTranslation(String allowOverlappingEvents) {
        try {
            CalendarResourceOverlappingEventsOptions option = CalendarResourceOverlappingEventsOptions.valueOf((String)allowOverlappingEvents);
            String translationKey = this.getAllowOverlappingEventsTranslationKey(option);
            return MessageHelper.getMessage((String)translationKey);
        }
        catch (Exception e) {
            return allowOverlappingEvents;
        }
    }

    private String getAllowOverlappingEventsTranslationKey(CalendarResourceOverlappingEventsOptions option) {
        return switch (option) {
            default -> throw new IncompatibleClassChangeError();
            case CalendarResourceOverlappingEventsOptions.ALWAYS -> "Zawsze";
            case CalendarResourceOverlappingEventsOptions.NEVER -> "Nigdy";
            case CalendarResourceOverlappingEventsOptions.WARNING -> "Wyswietl_ostrzezenie";
        };
    }
}

