/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.dao;

import com.suncode.pwfl.audit.Audit;
import com.suncode.pwfl.audit.dao.AuditDao;
import com.suncode.pwfl.audit.object.AuditFetchResult;
import com.suncode.pwfl.audit.object.FilterConfig;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.database.DatabaseType;
import com.suncode.pwfl.database.NativeSqlUtils;
import com.suncode.pwfl.support.HibernateEditableDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.AggregateProjection;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository(value="auditDao")
public class AuditDaoImpl
extends HibernateEditableDao<Audit, Long>
implements AuditDao {
    public AuditFetchResult getAudits(String orderBy, boolean asc, int offset, Integer limit, FilterConfig filterConfig) {
        return this.getAudits(orderBy, asc, offset, limit, filterConfig, null);
    }

    public AuditFetchResult getAuditsForLastActivity(String orderBy, boolean asc, int offset, int limit, FilterConfig filterConfig) {
        ProjectionList projectionList = Projections.projectionList().add((Projection)Property.forName((String)"userId"), "userId").add((Projection)Property.forName((String)"auditStarted"), "auditStarted").add((Projection)Property.forName((String)"auditType"), "auditType").add((Projection)Property.forName((String)"auditSuccess"), "auditSuccess").add((Projection)Property.forName((String)"auditParams"), "auditParams");
        return this.getAudits(orderBy, asc, offset, Integer.valueOf(limit), filterConfig, (Projection)projectionList);
    }

    private AuditFetchResult getAudits(String orderBy, boolean asc, int offset, Integer limit, FilterConfig filterConfig, Projection projection) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Audit.class);
        this.addFilterCriteria(criteria, filterConfig);
        AuditFetchResult auditFetchResult = new AuditFetchResult();
        auditFetchResult.setCount(this.getCount(criteria));
        criteria.setProjection(projection);
        criteria.setResultTransformer(projection == null ? Criteria.ROOT_ENTITY : Transformers.aliasToBean(Audit.class));
        auditFetchResult.setAudits(this.getAudits(criteria, orderBy, asc, offset, limit));
        return auditFetchResult;
    }

    private long getCount(DetachedCriteria criteria) {
        return this.countByCriteria(criteria);
    }

    private List<Audit> getAudits(DetachedCriteria criteria, String orderBy, boolean asc, int offset, Integer limit) {
        criteria.addOrder(asc ? Order.asc((String)orderBy) : Order.desc((String)orderBy));
        return this.findByCriteria(criteria, Integer.valueOf(offset), limit);
    }

    public Audit getAudit(Long auditId) {
        Criteria crit = this.getSession().createCriteria(Audit.class);
        crit.add((Criterion)Restrictions.eq((String)"id", (Object)auditId));
        return (Audit)crit.uniqueResult();
    }

    public HashMap<String, Long> getAvgDurations() {
        HashMap<String, Long> durations = new HashMap<String, Long>();
        ArrayList<String> auditTypeIds = new ArrayList<String>();
        AggregateProjection avgProjection = Projections.avg((String)"auditDuration");
        for (AuditTypes type : AuditTypes.values()) {
            auditTypeIds.add(type.toString());
        }
        for (String type : auditTypeIds) {
            if (type.equalsIgnoreCase("AUDIT_ALL")) continue;
            Criteria crit = this.getSession().createCriteria(Audit.class);
            crit.setProjection((Projection)avgProjection);
            crit.add((Criterion)Restrictions.eq((String)"auditType", (Object)type));
            Double avg = (Double)crit.uniqueResult();
            if (avg == null) continue;
            durations.put(type, Math.round(avg));
        }
        return durations;
    }

    private void addFilterCriteria(DetachedCriteria criteria, FilterConfig filterConfig) {
        String filterValue;
        if (StringUtils.isNotBlank((String)filterConfig.getUserId())) {
            criteria.add((Criterion)Restrictions.eq((String)"userId", (Object)filterConfig.getUserId()));
        }
        if (StringUtils.isNotBlank((String)filterConfig.getIpAddress())) {
            filterValue = StringUtils.replace((String)filterConfig.getIpAddress(), (String)"*", (String)"%");
            criteria.add(Restrictions.ilike((String)"ipAddress", (Object)filterValue));
        }
        if (StringUtils.isNotBlank((String)filterConfig.getThreadId())) {
            filterValue = StringUtils.replace((String)filterConfig.getThreadId(), (String)"*", (String)"%");
            criteria.add(Restrictions.ilike((String)"threadId", (Object)filterValue));
        }
        if (CollectionUtils.isNotEmpty((Collection)filterConfig.getAuditTypes())) {
            criteria.add(this.buildAuditTypeFilterCriteria(filterConfig));
        }
        if (filterConfig.getAuditStartedFrom() > 0L) {
            criteria.add((Criterion)Restrictions.ge((String)"auditStarted", (Object)filterConfig.getAuditStartedFrom()));
        }
        if (filterConfig.getAuditStartedTo() > 0L) {
            criteria.add((Criterion)Restrictions.le((String)"auditStarted", (Object)filterConfig.getAuditStartedTo()));
        }
        if (filterConfig.getAuditStoppedFrom() > 0L) {
            criteria.add((Criterion)Restrictions.ge((String)"auditStopped", (Object)filterConfig.getAuditStoppedFrom()));
        }
        if (filterConfig.getAuditStoppedTo() > 0L) {
            criteria.add((Criterion)Restrictions.le((String)"auditStopped", (Object)filterConfig.getAuditStoppedTo()));
        }
        if (filterConfig.getAuditDurationFrom() > 0L) {
            criteria.add((Criterion)Restrictions.ge((String)"auditDuration", (Object)filterConfig.getAuditDurationFrom()));
        }
        if (filterConfig.getAuditDurationTo() > 0L) {
            criteria.add((Criterion)Restrictions.le((String)"auditDuration", (Object)filterConfig.getAuditDurationTo()));
        }
        if (filterConfig.getAuditSuccess() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"auditSuccess", (Object)filterConfig.getAuditSuccess()));
        }
        if (StringUtils.isNotBlank((String)filterConfig.getAuditDetails())) {
            filterValue = StringUtils.replace((String)filterConfig.getAuditDetails(), (String)"*", (String)"%");
            if (NativeSqlUtils.getDatabaseType() == DatabaseType.MSSQL) {
                criteria.add(Restrictions.sqlRestriction((String)("cast(this_.auditParams as varchar(max)) LIKE '%" + filterValue + "%'")));
            } else {
                criteria.add(Restrictions.ilike((String)"auditParams", (Object)("%" + filterValue + "%")));
            }
        }
    }

    private Criterion buildAuditTypeFilterCriteria(FilterConfig filterConfig) {
        List<Criterion> predicates = filterConfig.getAuditTypes().stream().map(auditType -> {
            if (filterConfig.isAuditTypesBlackList()) {
                return Restrictions.ne((String)"auditType", (Object)auditType);
            }
            return Restrictions.eq((String)"auditType", (Object)auditType);
        }).collect(Collectors.toList());
        if (filterConfig.isAuditTypesBlackList()) {
            return Restrictions.and((Criterion[])predicates.toArray(new Criterion[0]));
        }
        return Restrictions.or((Criterion[])predicates.toArray(new Criterion[0]));
    }

    public int deleteAudits(Date date) {
        String query = "delete from Audit where auditStarted <= :date";
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("date", date.getTime());
        return this.executeAuditRemoval(query, parameters);
    }

    public int deleteAudits(Date dateFrom, Date dateTo) {
        String query = "delete from Audit where auditStarted >= :dateFrom and auditStarted <= :dateTo";
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("dateFrom", dateFrom.getTime());
        parameters.put("dateTo", dateTo.getTime());
        return this.executeAuditRemoval(query, parameters);
    }

    public int deleteAudits(String userId) {
        String query = "delete from Audit where userId = :userId";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", userId);
        return this.executeAuditRemoval(query, parameters);
    }

    private int executeAuditRemoval(String query, HashMap<String, Object> parameters) {
        Query hqlQuery = this.getSession().createQuery(query);
        for (String parameter : parameters.keySet()) {
            hqlQuery.setParameter(parameter, parameters.get(parameter));
        }
        return hqlQuery.executeUpdate();
    }
}

