/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit;

import com.google.common.util.concurrent.UncheckedExecutionException;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.administration.user.UserInfoCache;
import com.suncode.pwfl.audit.AuditDtoCore;
import com.suncode.pwfl.audit.AuditWrapper;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.form.AuditHandler;
import com.suncode.pwfl.audit.util.AuditCategories;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.database.NativeSqlUtils;
import com.suncode.pwfl.database.sequence.SequenceUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.MDC;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Audit
implements AuditHandler {
    private static final Logger log = LoggerFactory.getLogger(Audit.class);
    private long id;
    private String userId;
    private String ipAddress;
    private String threadId;
    private String auditType;
    private long auditStarted;
    private long auditStopped;
    private long auditDuration;
    private boolean auditSuccess;
    private String auditParams;
    private String auditCategory;
    private static org.apache.log4j.Logger allAuditLog;
    private static org.apache.log4j.Logger categoryAuditLog;
    private static org.apache.log4j.Logger actionAuditLog;

    public Audit() {
        this.userId = "";
        this.ipAddress = "";
        this.threadId = "";
        this.auditType = "";
        this.auditStarted = 0L;
        this.auditStopped = 0L;
        this.auditDuration = 0L;
        this.auditSuccess = false;
    }

    public Audit(String userId, AuditTypes auditType) {
        this.userId = userId;
        this.auditType = auditType.toString();
        this.auditCategory = AuditCategories.getCategoryNameForAudit((AuditTypes)auditType);
    }

    public void changeAuditType(AuditTypes auditType) {
        this.auditType = auditType.toString();
        this.auditCategory = AuditCategories.getCategoryNameForAudit((AuditTypes)auditType);
    }

    public void start() {
        this.auditStarted = System.currentTimeMillis();
    }

    public void stop() {
        this.auditStopped = System.currentTimeMillis();
        this.auditDuration = this.auditStopped - this.auditStarted;
    }

    public void log() {
        long auditId = this.getAuditId();
        UserInfo userInfo = Audit.getUserInfo((String)this.userId);
        boolean isAnonymousUser = userInfo != null && userInfo.isAnonymous();
        MDC.put((String)"userip", (String)(isAnonymousUser ? ManualAuditBuilder.UNKNOWN : this.ipAddress));
        MDC.put((String)"auditId", (Object)auditId);
        MDC.put((String)"userId", (String)StringEscapeUtils.escapeSql((String)this.userId));
        MDC.put((String)"auditType", (String)StringEscapeUtils.escapeSql((String)this.auditType));
        MDC.put((String)"auditStarted", (Object)this.auditStarted);
        MDC.put((String)"auditStopped", (Object)this.auditStopped);
        MDC.put((String)"auditDuration", (Object)this.auditDuration);
        MDC.put((String)"auditSuccess", (String)StringEscapeUtils.escapeSql((String)NativeSqlUtils.getBooleanValue((boolean)this.auditSuccess)));
        MDC.put((String)"auditParams", (String)StringEscapeUtils.escapeSql((String)this.auditParams));
        allAuditLog = org.apache.log4j.Logger.getLogger((String)"AUDIT.".concat(AuditTypes.AUDIT_ALL.toString()));
        categoryAuditLog = org.apache.log4j.Logger.getLogger((String)"AUDIT.".concat(this.auditCategory));
        actionAuditLog = org.apache.log4j.Logger.getLogger((String)"AUDIT.".concat(this.auditType));
        String logMsg = this.auditType.concat(", Czas trwania: ").concat(String.valueOf(this.auditDuration)).concat(" ms");
        logMsg = logMsg.concat(", Sukces: ").concat(String.valueOf(this.auditSuccess));
        allAuditLog.info((Object)logMsg);
        categoryAuditLog.info((Object)logMsg);
        actionAuditLog.info((Object)logMsg);
        MDC.remove((String)"auditId");
        MDC.remove((String)"userId");
        MDC.remove((String)"auditType");
        MDC.remove((String)"auditStarted");
        MDC.remove((String)"auditStopped");
        MDC.remove((String)"auditDuration");
        MDC.remove((String)"auditSuccess");
        MDC.remove((String)"auditParams");
    }

    @Nullable
    private static UserInfo getUserInfo(String userId) {
        UserInfo userInfo = null;
        if (!userId.equals(ManualAuditBuilder.UNKNOWN)) {
            try {
                userInfo = UserInfoCache.get().get(userId);
            }
            catch (UncheckedExecutionException e) {
                log.warn("{} username not found while creating audit.", (Object)userId);
            }
        }
        return userInfo;
    }

    private long getAuditId() {
        return SequenceUtils.nextValue((String)"pm_audits_id_seq");
    }

    public static Audit create(AuditWrapper wrapper) {
        Audit audit = new Audit();
        audit.setUserId(wrapper.getUserId());
        UserInfo userInfo = Audit.getUserInfo((String)wrapper.getUserId());
        boolean isAnonymousUser = userInfo != null && userInfo.isAnonymous();
        audit.setIpAddress(isAnonymousUser ? ManualAuditBuilder.UNKNOWN : wrapper.getIpAddress());
        audit.setThreadId(wrapper.getThreadId());
        audit.setAuditType(wrapper.getAuditType());
        audit.setAuditStarted(wrapper.getAuditStarted());
        audit.setAuditStopped(wrapper.getAuditStopped());
        audit.setAuditDuration(wrapper.getAuditDuration());
        audit.setAuditSuccess(wrapper.isAuditSuccess());
        audit.setAuditParams(wrapper.getAuditParams());
        audit.setAuditCategory(wrapper.getAuditCategory());
        return audit;
    }

    public AuditDtoCore toAuditDtoCore() {
        return AuditDtoCore.builder().id(this.id).userId(this.userId).ipAddress(this.ipAddress).threadId(this.threadId).auditType(this.auditType).auditStarted(this.auditStarted).auditStopped(this.auditStopped).auditDuration(this.auditDuration).auditSuccess(this.auditSuccess).auditParams(this.auditParams).auditCategory(this.auditCategory).build();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public void setThreadId(String threadId) {
        this.threadId = threadId;
    }

    public String getAuditType() {
        return this.auditType;
    }

    public void setAuditType(String auditType) {
        this.auditType = auditType;
    }

    public long getAuditStarted() {
        return this.auditStarted;
    }

    public void setAuditStarted(long auditStarted) {
        this.auditStarted = auditStarted;
    }

    public long getAuditStopped() {
        return this.auditStopped;
    }

    public void setAuditStopped(long auditStopped) {
        this.auditStopped = auditStopped;
    }

    public long getAuditDuration() {
        return this.auditDuration;
    }

    public void setAuditDuration(long auditDuration) {
        this.auditDuration = auditDuration;
    }

    public boolean isAuditSuccess() {
        return this.auditSuccess;
    }

    public void setAuditSuccess(boolean auditSuccess) {
        this.auditSuccess = auditSuccess;
    }

    public String getAuditParams() {
        return this.auditParams;
    }

    public void setAuditParams(String auditParams) {
        this.auditParams = auditParams;
    }

    public String getAuditCategory() {
        return this.auditCategory;
    }

    public void setAuditCategory(String auditCategory) {
        this.auditCategory = auditCategory;
    }
}

