/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionsFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(PermissionsFormatter.class);
    private final String resourceNameKey = "resourceName";
    private final String isGroupKey = "isGroup";
    private final String systemKey = "system";
    private final String adminKey = "admin";
    private final String archiveKey = "archive";
    private final String docClassesKey = "docClasses";
    private final String linkKey = "link";
    private final String workflowKey = "workflow";
    private final String createProcessKey = "createProcess";
    private final String searchProcessKey = "searchProcess";
    private final String statsKey = "stats";
    private final String calendarKey = "calendar";
    private final String userAccountKey = "userAccount";
    private final String reportsKey = "reports";
    private final String viewsKey = "views";
    private final String pluginsKey = "plugins";
    private final String historyKey = "history";
    private final String hideSystemDashboardKey = "hideSystemDashboard";
    private final String partialPermissionsKey = "partialPermissions";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String resourceName = map.get("resourceName");
            String isGroup = map.get("isGroup");
            String system = map.get("system");
            String admin = map.get("admin");
            String archive = map.get("archive");
            String docClasses = map.get("docClasses");
            String link = map.get("link");
            String workflow = map.get("workflow");
            String createProcess = map.get("createProcess");
            String searchProcess = map.get("searchProcess");
            String stats = map.get("stats");
            String calendar = map.get("calendar");
            String userAccount = map.get("userAccount");
            String reports = map.get("reports");
            String views = map.get("views");
            String plugins = map.get("plugins");
            String history = map.get("history");
            String hideSystemDashboard = map.get("hideSystemDashboard");
            String partialPermissions = map.get("partialPermissions");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)resourceName)) {
                formattedMap.put(AuditParamsNames.RESOURCE_NAME.name(), this.formatTextValueChange(resourceName));
            }
            if (StringUtils.isNotBlank((CharSequence)isGroup)) {
                formattedMap.put(AuditParamsNames.IS_GROUP.name(), this.formatTextValueChange(isGroup));
            }
            if (StringUtils.isNotBlank((CharSequence)system)) {
                formattedMap.put(AuditParamsNames.PERMISSION_SYSTEM.name(), this.formatTextValueChange(system));
            }
            if (StringUtils.isNotBlank((CharSequence)admin)) {
                formattedMap.put(AuditParamsNames.PERMISSION_ADMIN.name(), this.formatTextValueChange(admin));
            }
            if (StringUtils.isNotBlank((CharSequence)archive)) {
                formattedMap.put(AuditParamsNames.PERMISSION_ARCHIVE.name(), this.formatTextValueChange(archive));
            }
            if (StringUtils.isNotBlank((CharSequence)docClasses)) {
                formattedMap.put(AuditParamsNames.PERMISSION_DOC_CLASSES.name(), this.formatTextValueChange(docClasses));
            }
            if (StringUtils.isNotBlank((CharSequence)link)) {
                formattedMap.put(AuditParamsNames.PERMISSION_LINK.name(), this.formatTextValueChange(link));
            }
            if (StringUtils.isNotBlank((CharSequence)workflow)) {
                formattedMap.put(AuditParamsNames.PERMISSION_WORKFLOW.name(), this.formatTextValueChange(workflow));
            }
            if (StringUtils.isNotBlank((CharSequence)createProcess)) {
                formattedMap.put(AuditParamsNames.PERMISSION_CREATE_PROCESS.name(), this.formatTextValueChange(createProcess));
            }
            if (StringUtils.isNotBlank((CharSequence)searchProcess)) {
                formattedMap.put(AuditParamsNames.PERMISSION_SEARCH_PROCESS.name(), this.formatTextValueChange(searchProcess));
            }
            if (StringUtils.isNotBlank((CharSequence)stats)) {
                formattedMap.put(AuditParamsNames.PERMISSION_STATS.name(), this.formatTextValueChange(stats));
            }
            if (StringUtils.isNotBlank((CharSequence)calendar)) {
                formattedMap.put(AuditParamsNames.PERMISSION_CALENDAR.name(), this.formatTextValueChange(calendar));
            }
            if (StringUtils.isNotBlank((CharSequence)userAccount)) {
                formattedMap.put(AuditParamsNames.PERMISSION_USER_ACCOUNT.name(), this.formatTextValueChange(userAccount));
            }
            if (StringUtils.isNotBlank((CharSequence)reports)) {
                formattedMap.put(AuditParamsNames.PERMISSION_REPORTS.name(), this.formatTextValueChange(reports));
            }
            if (StringUtils.isNotBlank((CharSequence)views)) {
                formattedMap.put(AuditParamsNames.PERMISSION_VIEWS.name(), this.formatTextValueChange(views));
            }
            if (StringUtils.isNotBlank((CharSequence)plugins)) {
                formattedMap.put(AuditParamsNames.PERMISSION_PLUGINS.name(), this.formatTextValueChange(plugins));
            }
            if (StringUtils.isNotBlank((CharSequence)history)) {
                formattedMap.put(AuditParamsNames.PERMISSION_HISTORY.name(), this.formatTextValueChange(history));
            }
            if (StringUtils.isNotBlank((CharSequence)hideSystemDashboard)) {
                formattedMap.put(AuditParamsNames.PERMISSION_HIDE_SYSTEM_DASHBOARD.name(), this.formatTextValueChange(hideSystemDashboard));
            }
            if (StringUtils.isNotBlank((CharSequence)partialPermissions)) {
                formattedMap.put(AuditParamsNames.PERMISSION_PARTIAL_REMOVAL.name(), this.formatTextValueChange(partialPermissions));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

