/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(DeviceFormatter.class);
    private final String deviceIdKey = "deviceId";
    private final String deviceNameKey = "deviceName";
    private final String devicePathKey = "devicePath";
    private final String deviceSizeKey = "deviceSize";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String deviceId = map.get("deviceId");
            String deviceName = map.get("deviceName");
            String devicePath = map.get("devicePath");
            String deviceSize = map.get("deviceSize");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.DEVICE_ID.toString(), deviceId);
            formattedMap.put(AuditParamsNames.DEVICE_NAME.toString(), this.getCustomName(deviceName));
            formattedMap.put(AuditParamsNames.DEVICE_PATH.toString(), this.getCustomName(devicePath));
            formattedMap.put(AuditParamsNames.DEVICE_SIZE.toString(), this.getCustomName(deviceSize));
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

