/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateDocumentClassAssociationFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(UpdateDocumentClassAssociationFormatter.class);
    private static final String baseClassKey = "baseClass";
    private static final String associatedClassKey = "associatedClass";
    private static final String associatedIndexesKey = "associatedIndexes";
    private static final String oldAssociatedIndexesKey = "oldAssociatedIndexes";
    private static final String displayedIndexesKey = "displayedIndexes";
    private static final String oldDisplayedIndexesKey = "oldDisplayedIndexes";
    private static final String separatorKey = "separator";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String baseClass = map.get(baseClassKey);
            String associatedClass = map.get(associatedClassKey);
            String associatedIndexes = map.get(associatedIndexesKey);
            String oldAssociatedIndexes = map.get(oldAssociatedIndexesKey);
            String displayedIndexes = map.get(displayedIndexesKey);
            String oldDisplayedIndexes = map.get(oldDisplayedIndexesKey);
            String separator = map.get(separatorKey);
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.BASE_CLASS.toString(), baseClass);
            formattedMap.put(AuditParamsNames.ASSOCIATED_CLASS.toString(), this.getDocumentClassName(associatedClass));
            formattedMap.put(AuditParamsNames.NEW_ASSOCIATED_INDEXES.toString(), this.getAssociatedIndexes(associatedIndexes));
            formattedMap.put(AuditParamsNames.OLD_ASSOCIATED_INDEXES.toString(), this.getAssociatedIndexes(oldAssociatedIndexes));
            formattedMap.put(AuditParamsNames.NEW_DISPLAYED_INDEXES.toString(), displayedIndexes);
            formattedMap.put(AuditParamsNames.OLD_DISPLAYED_INDEXES.toString(), oldDisplayedIndexes);
            formattedMap.put(AuditParamsNames.SEPARATOR.toString(), separator);
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String getDocumentClassName(String documentClass) {
        if (StringUtils.isNotBlank((String)documentClass) && documentClass.split(";").length > 1) {
            String[] documentClasses = documentClass.split(";");
            return documentClasses[0] + " > " + documentClasses[0];
        }
        return documentClass;
    }

    private String getAssociatedIndexes(String indexes) {
        return Arrays.stream(indexes.split(";")).map(arg_0 -> this.getIndexesPair(arg_0)).collect(Collectors.joining("; "));
    }

    private String getIndexesPair(String joinedIndexes) {
        String[] indexes = joinedIndexes.split(",");
        return indexes[0] + " -> " + indexes[1];
    }
}

