/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleApiAuthenticationFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(GoogleApiAuthenticationFormatter.class);
    private final String idKey = "id";
    private final String nameKey = "name";
    private final String defaultConfigurationKey = "defaultConfiguration";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String id = map.get("id");
            String name = map.get("name");
            String defaultConfiguration = map.get("defaultConfiguration");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                formattedMap.put(AuditParamsNames.CONFIGURATION_ID.name(), id);
            }
            if (StringUtils.isNotBlank((CharSequence)name)) {
                formattedMap.put(AuditParamsNames.CONFIGURATION_NAME.name(), this.getCustomName(name));
            }
            if (StringUtils.isNotBlank((CharSequence)defaultConfiguration)) {
                formattedMap.put(AuditParamsNames.CONFIGURATION_DEFAULT_CONFIGURATION.name(), this.getCustomName(defaultConfiguration));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

