(function (Ext) {
  Ext.define('Suncode.audit.view.DetailsWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.details-window',
    title: PW.t('auditDetails'),
    modal: true,
    shadow: false,
    constrain: true,
    layout: 'fit',
    minWidth: 800,
    minHeight: 800,
    autoWidth: true,
    autoHeight: true,
    initComponent: function () {
      var auditDetails = this.auditDetails;
      var mainInfo = auditDetails.mainInfo;
      var detailsInfo = auditDetails.detailsInfo;
      var detailsInfoItems = new Array();

      if (Ext.isEmpty(detailsInfo) || !Ext.isArray(detailsInfo)) {
        detailsInfoItems.push({
          xtype: 'label',
          text: PW.t('noDetails'),
        });
      } else {
        for (var i = 0; i < detailsInfo.length; i++) {
          var paramElem = detailsInfo[i];

          detailsInfoItems.push({
            xtype: 'displayfield',
            fieldLabel: paramElem.paramName,
            labelCls: 'x-audit-label',
            labelWidth: 250,
            anchor: '100%',
            value: Ext.String.htmlEncode(paramElem.paramValue),
            fieldStyle: 'height: auto; white-space: pre-wrap;',
          });
        }
      }

      this.items = [
        {
          xtype: 'form',
          border: false,
          frame: false,
          width: 800,
          height: 550,
          padding: 10,
          layout: {
            type: 'vbox',
            align: 'stretch',
          },
          items: [
            {
              xtype: 'fieldset',
              autoWidth: true,
              title: PW.t('generalData'),
              items: [
                {
                  xtype: 'displayfield',
                  fieldLabel: PW.t('user'),
                  labelCls: 'x-audit-label',
                  labelWidth: 250,
                  fieldStyle: 'height: auto',
                  anchor: '100%',
                  value: Ext.String.htmlEncode(mainInfo.userName),
                },
                {
                  xtype: 'displayfield',
                  fieldLabel: PW.t('ipAddress'),
                  labelCls: 'x-audit-label',
                  labelWidth: 250,
                  anchor: '100%',
                  value: mainInfo.ipAddress,
                },
                {
                  xtype: 'displayfield',
                  fieldLabel: PW.t('threadId'),
                  labelCls: 'x-audit-label',
                  labelWidth: 250,
                  anchor: '100%',
                  value: mainInfo.threadId,
                },
                {
                  xtype: 'displayfield',
                  fieldLabel: PW.t('name'),
                  labelCls: 'x-audit-label',
                  labelWidth: 250,
                  anchor: '100%',
                  value: mainInfo.auditType,
                },
                {
                  xtype: 'displayfield',
                  fieldLabel: PW.t('startTime'),
                  labelCls: 'x-audit-label',
                  labelWidth: 250,
                  anchor: '100%',
                  value: mainInfo.auditStarted,
                },
                {
                  xtype: 'displayfield',
                  fieldLabel: PW.t('stopTime'),
                  labelCls: 'x-audit-label',
                  labelWidth: 250,
                  anchor: '100%',
                  value: mainInfo.auditStopped,
                },
                {
                  xtype: 'displayfield',
                  fieldLabel: PW.t('duration'),
                  labelCls: 'x-audit-label',
                  labelWidth: 250,
                  anchor: '100%',
                  value: mainInfo.auditDuration,
                },
                {
                  xtype: 'checkbox',
                  fieldLabel: PW.t('success'),
                  labelCls: 'x-audit-label',
                  labelClsExtra: mainInfo.auditSuccess ? 'x-audit-success-details' : 'x-audit-failed-details',
                  labelWidth: 250,
                  anchor: '100%',
                  readOnly: true,
                  checked: mainInfo.auditSuccess,
                },
              ],
            },
            {
              xtype: 'fieldset',
              flex: 1,
              autoScroll: true,
              title: PW.t('details'),
              items: detailsInfoItems,
            },
          ],
        },
      ];

      this.callParent();
    },
  });
})(this.Ext4);
